/*!
 * 
 * Copyright (c) 2009 - 2011, javalikescript@free.fr (SPYL). All rights reserved.
 * JLS is licensed under LGPL, see the license.txt file that accompanied this code.
 * 
 */

// Add default option variable
if (typeof jlsOptions == 'undefined') {
    jlsOptions = {};
}

// Native namespace
var _native = {};

/*
 * Library boot
 */
_native.boot = {};
_native.boot.emptyFunction = function() {};
_native.boot.unsupportedFunction = function() {
    throw 'Unsupported native operation';
};
_native.boot.unsupportedClass = function() {
    throw 'Unsupported native class';
};
_native.boot.log = _native.boot.emptyFunction;
if ((typeof console != 'undefined') && ('log' in console)) {
    //_native.boot.log = console.log;
	_native.boot.log = function(msg) { // Chrome has a console but needs wrapping...
		console.log(msg);
	};
}
// Find the default script path
(function() {
    var bootstrap = 'bootstrap.js';
    var path = '.'; // default
    var scriptTags = document.getElementsByTagName('script');
    for (var i = 0; i < scriptTags.length; i++) {
        var src = scriptTags[i].getAttribute('src');
        if (!src) {
            continue;
        }
        var i = src.lastIndexOf('/' + bootstrap);
        if ((i >= 0) && (i == src.length - bootstrap.length - 1)) {
            path = src.substring(0, src.length - bootstrap.length - 1);
            break;
        } else if (src == bootstrap) {
            path = '.';
            break;
        }
    }
    _native.boot.defaultScriptPath = path;
})();


_native.boot.httpRequest = function(url, options) {
	this._url = url;
	this._options = {
	    method : 'post',
	    asynchronous : true,
	    contentType : 'application/x-www-form-urlencoded',
	    encoding : 'UTF-8',
	    parameters : '',
	    user : null,
	    password : null,
        onException : _native.boot.emptyFunction,
        onFailure : _native.boot.emptyFunction,
        onSuccess : _native.boot.emptyFunction
	};
	if (options) {
		for (var key in options) {
			this._options[key] = options[key];
		}
	}
	this._xhr = _native.boot.httpRequest.newXHR();
};
_native.boot.httpRequest.newXHR = function() {
	try {
	    return new XMLHttpRequest()
	}
	catch (e) {
		try {
		    return new ActiveXObject('Msxml2.XMLHTTP')
		}
		catch (e) {
			try {
			    return new ActiveXObject('Microsoft.XMLHTTP')
			}
			catch (e) {
				return false;
			}
		}
	}
};
_native.boot.httpRequest.prototype.getXHR = function() {
	return this._xhr;
};
_native.boot.httpRequest.prototype.getStatus = function() {
	return this._xhr.status || 0;
};
_native.boot.httpRequest.prototype.onStateChange = function() {
    var readyState = this._xhr.readyState;
    //_native.core.log(0, '_native.boot.xmlHttpRequest.onStateChange(' + readyState + ')');
    if (readyState != 4) { // Not completed
    	return;
    }
    var status = this.getStatus();
    try {
        if (((status >= 200) && (status < 300)) || (status == 304)) {
        	this._options.onSuccess.call(this);
        } else {
        	this._options.onFailure.call(this);
        }
    }
    catch (e) {
    	this._options.onException.call(this, e);
    }
    finally {
        this._xhr.onreadystatechange = _native.boot.emptyFunction;
    }
};
_native.boot.httpRequest.prototype.send = function() {
    //_native.core.log(0, '_native.boot.xmlHttpRequest.send(), ' + this._options.method + ': "' + this._url + '"');
	if ((this._options.user != null) && (this._options.password != null)) {
		this._xhr.open(this._options.method.toUpperCase(), this._url,
		        this._options.asynchronous, this._options.user,
		        this._options.password);
	} else {
		this._xhr.open(this._options.method.toUpperCase(), this._url,
		        this._options.asynchronous);
	}
	var self = this;
	this._xhr.onreadystatechange = function () {
		self.onStateChange();
	};
    var headers = {
    	      'Accept': 'text/javascript, text/html, application/xml, text/xml, */*'
    	    };
    if (this._options.method == 'post') {
        headers['Content-type'] = this._options.contentType + (this._options.encoding ? '; charset=' + this._options.encoding : '');
    }
    for (var name in headers) {
        this._xhr.setRequestHeader(name, headers[name]);
    }
    var params = (typeof this._options.parameters == 'string') ? this._options.parameters : Object.toQueryString(this._options.parameters);
	var body = (this._options.method == 'post') ? (this._options.postBody || params) : null;
	this._xhr.send(body);
    /* Force Firefox to handle ready state 4 for synchronous requests */
    if (!this._options.asynchronous && this._xhr.overrideMimeType) {
        this.onStateChange();
    }
	return this;
};


/*
 * Library core From "jls generateNativeLibraryAPI.js"
 */
_native.core = {};
_native.core.log = function(level, msg) {
    _native.boot.log(msg);
};
_native.core.logLevel = _native.boot.emptyFunction;
_native.core.exceptionHandler = _native.boot.emptyFunction;
_native.core.sleep = _native.boot.emptyFunction;
_native.core._scriptPath = [];
_native.core.getResourceAsString = function(path) {
    //_native.core.log(0, '_native.core.getResourceAsString("' + path + '")');
    var text = null;
    for (var i = 0; i < _native.core._scriptPath.length; i++) {
        var url = _native.core._scriptPath[i] + '/' + path;
        //_native.core.log(0, 'try url "' + url + '"');
        var exception = null;
        var status = 0;
        new _native.boot.httpRequest(url, {
            method :'get',
            asynchronous :false,
            onException : function(e) {
                exception = e;
            },
            onFailure : function() {
                status = this.getStatus();
            },
            onSuccess : function() {
                text = this.getXHR().responseText;
            }
        }).send();
        if (exception != null) {
            throw exception;
        } else if (status == 0) {
            break;
        } else if (status != 404) {
            throw 'Unsupported status ' + status + ' for script path "' + _native.core._scriptPath[i] + '"';
        }
    }
    if (text == null) {
        throw 'Script not found "' + path + '"';
    }
    return text;
};
_native.core.getResourceAsByteArray = _native.boot.emptyFunction;
_native.core.evalScript = function(path) {
    //_native.core.log(0, '_native.core.evalScript("' + path + '")');
    eval(_native.core.getResourceAsString(path));
};
_native.core.loadLibrary = _native.boot.unsupportedFunction;
_native.core.visitPaths = _native.boot.emptyFunction;
_native.core.gc = _native.boot.unsupportedFunction;
_native.core.dumpHead = _native.boot.unsupportedFunction;
_native.core.exit = _native.boot.unsupportedFunction;
_native.core.halt = _native.boot.unsupportedFunction;
_native.core.system = _native.boot.unsupportedFunction;
_native.core.signal = _native.boot.unsupportedFunction;
_native.core.raise = _native.boot.unsupportedFunction;
_native.core.getSignalCounters = _native.boot.unsupportedFunction;
_native.core.registerSignalMonitor = _native.boot.unsupportedFunction;
_native.core.handleSignal = _native.boot.unsupportedFunction;
_native.core.getEnv = _native.boot.unsupportedFunction;
_native.core.boot = _native.boot.unsupportedFunction;
_native.core.addPath = function(path) {
    // Check for duplicate
    var i = _native.core._scriptPath.length;
    while (--i >= 0) {
        if (_native.core._scriptPath[i] == path) {
            break;
        }
    }
    if (i < 0) {
        _native.core._scriptPath.push(path);
    }
};
_native.core.arguments = null;
/*
Browser CodeName: Mozilla
Browser Name: Microsoft Internet Explorer
Browser Version: 4.0 (compatible; MSIE 8.0; Windows NT 6.1; Win64; x64; Trident/4.0; .NET CLR 2.0.50727; SLCC2; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C)
User-agent header: Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Win64; x64; Trident/4.0; .NET CLR 2.0.50727; SLCC2; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C)

Browser CodeName: Mozilla
Browser Name: Netscape
Browser Version: 5.0 (Windows; fr)
User-agent header: Mozilla/5.0 (Windows; U; Windows NT 6.1; fr; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13

Browser CodeName: Mozilla
Browser Name: Netscape
Browser Version: 5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.10 (KHTML, like Gecko) Chrome/8.0.552.237 Safari/534.10
User-agent header: Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/534.10 (KHTML, like Gecko) Chrome/8.0.552.237 Safari/534.10
 */
_native.core.properties = { // From "jls systemProperties.js json"
  'browser' : navigator.appName,
  'browser.vendor' : navigator.userAgent, // TODO Use Crome, Gecko, IE, Opera, WebKit
  'browser.version' : navigator.appVersion,
  'browser.cookieEnabled' : navigator.cookieEnabled,
  'cpu.endian' : 'little',
  'cpu.pointer.size' : '4',
  'file.encoding' : 'UTF-8',
  'file.separator' : '/',
  'gui.toolkit' : 'html',
  'javascript.engine' : '?',
  'javascript.version' : '180',
  'jls.bootstrap.filename' : 'bootstrap.js',
  'jls.extension.path' : '',
  'jls.home' : '.',
  'jls.library.path' : '.',
  'jls.logger.logLevel' : 'warn',
  'jls.programname' : 'jls',
  'jls.script.path' : _native.boot.defaultScriptPath,
  'jls.vendor' : 'spyl',
  'jls.vendor.url' : 'http://javalikescript.free.fr/',
  'jls.version' : '0.1',
  'line.separator' : '\n',
  'os.architecture' : 'n/a',
  'os.hostname' : 'n/a',
  'os.release' : 'n/a',
  'os.sysname' : navigator.platform,
  'path.separator' : ';'
};
_native.core.SIGINT = 2;
_native.core.SIGILL = 4;
_native.core.SIGFPE = 8;
_native.core.SIGSEGV = 11;
_native.core.SIGTERM = 15;
_native.core.SIGBREAK = 21;
_native.core.SIGABRT = 22;
_native.core.SIG_ERR = -1;
_native.core.SIG_DFL = 0;
_native.core.SIG_IGN = 1;
_native.core.SIG_USR = 2;
/*
 * Class _native.core.ByteArray
 */
_native.core.ByteArray = function(capacity, adoptable) {
    this._array = null;
    this._readOnly = false;
    if (typeof capacity == 'number') {
        if (typeof adoptable == 'number') {
            throw 'Unsupported native operation (new ByteArray from pointer)';
        }
        this._array = new Array(capacity);
    } else if (typeof capacity == 'string') {
        this._array = new Array(/*capacity.length * 2*/);
    	for (var i = 0; i < capacity.length; i++) {
    		var c = capacity.charCodeAt(i);
            this._array.push(c & 0xff);
            this._array.push((c >>> 8) & 0xff);
    	}
        _native.core.log(0, 'ByteArray.construct(), this._array.length: ' + this._array.length);
        this._readOnly = ! adoptable;
    } else {
        throw 'Illegal argument type ' + (typeof capacity);
    }
};
_native.core.ByteArray.prototype.free = function() {
    this._array = null;
};
_native.core.ByteArray.prototype.size = function() {
    return this._array.length;
};
_native.core.ByteArray.prototype.put = function(offset, value) {
    this._array[offset] = value & 0xff;
};
_native.core.ByteArray.prototype.get = function(offset) {
    return this._array[offset];
};
_native.core.ByteArray.prototype.putString = _native.boot.unsupportedFunction; // TODO
_native.core.ByteArray.prototype.getString = _native.boot.unsupportedFunction; // TODO
_native.core.ByteArray.prototype.putChars = _native.boot.unsupportedFunction; // TODO
_native.core.ByteArray.prototype.getChars = function(at, length) {
    var s = '';
    for (var i = at; i < length; i++) {
        var c = this._array[i * 2] | (this._array[i * 2 + 1] << 8);
        s += String.fromCharCode(c);
    }
    return s;
};
_native.core.ByteArray.prototype.toNewChars = function(length) {
    return this.getChars(0, length);
};
_native.core.ByteArray.prototype.pointer = _native.boot.unsupportedFunction;
_native.core.ByteArray.prototype.memcpy = function(offset, byteArray, at, length) {
    //_native.core.log(0, 'ByteArray.memcpy(' + offset + ', ?, ' + at + ', ' + length + ')');
    for (var i = 0; i < length; i++) {
        this._array[offset + i] = byteArray._array[at + i];
    }
};
_native.core.ByteArray.prototype.setPointer = _native.boot.unsupportedFunction;
_native.core.ByteArray.prototype.resetPointer = _native.boot.unsupportedFunction;
_native.core.ByteArray.prototype.isReadOnly = function() {
    return this._readOnly;
};
/*
 * Unsupported classes
 */
_native.core.Thread = _native.boot.unsupportedClass;
_native.core.Lock = _native.boot.unsupportedClass;
_native.core.Monitor = _native.boot.unsupportedClass;
_native.core.Process = _native.boot.unsupportedClass;
_native.core.ProcessAttr = _native.boot.unsupportedClass;

// Update script path
if ('arguments' in jlsOptions) {
    _native.core.arguments = jlsOptions.arguments;
}
// Update properties
if ('properties' in jlsOptions) {
	for (var name in jlsOptions.properties) {
		_native.core.properties[name] = jlsOptions.properties[name];
	}
}
// Update script path
_native.core._scriptPath = _native.core.properties['jls.script.path'].split(/[;:]/);


/**
 * jls Base framework.
 * All the framework objects are created under the jls namespace.
 * The default objects are extended using prototype like behaviors.
 * 
 * @namespace
 * @see jls.lang
 */
var jls = {};

/**
 * @namespace Provides base classes for the jls language.
 * @see jls.lang.Exception
 * @see jls.lang.Logger
 * @see jls.lang.ClassLoader
 */
jls.lang = {};

// Load prototype light
_native.core.evalScript('plight.js');

// Load base classes
_native.core.evalScript('jls/lang/Exception.js');
_native.core.evalScript('jls/lang/Logger.js');

/**
 * Logger.
 * 
 * @type jls.lang.Logger
 * @memberOf jls
 */
jls.logger = new jls.lang.Logger(jls.lang.Logger.WARN);
if ('jls.logger.logLevel' in _native.core.properties) {
    jls.logger.setLogLevel(_native.core.properties['jls.logger.logLevel']);
}

_native.core.evalScript('jls/lang/ClassLoader.js');

/**
 * ClassLoader.
 * 
 * @type jls.lang.ClassLoader
 * @memberOf jls
 */
jls.loader = new jls.lang.ClassLoader();

// Register base classes
jls.loader.provide('jls.lang.Exception', true);
jls.loader.provide('jls.lang.Logger', true);
jls.loader.provide('jls.lang.ClassLoader', true);

