jls.loader.provide('jls.gui.CardLayout');

jls.loader.require('jls.gui.Layout');
jls.loader.require('jls.gui.FlowLayout');

/**
 * @augments jls.gui.Layout
 * @class This class represents a card layout. The children can have the same size and only one is visible.
 */
jls.gui.CardLayout = jls.lang.Class.create(jls.gui.Layout,
{
    initialize : function($super, element) {
    	this._selectedIndex = 0;
        $super(element);
    },
    /*onCreate : function() {
        var childCount = this._element.getChildCount();
        for (var i = 0; i < childCount; i++) {
            var child = this._element.getChild(i);
            child.getStyle().setProperty('visibility', i == this._selectedIndex ? 'visible' : 'hidden');
        }
    },*/
    show : function(index) {
    	//jls.logger.warn('show(' + index + ')');
    	if (this._selectedIndex >= 0) {
        	this._element.getChild(this._selectedIndex).getStyle().setProperty('visibility', 'hidden');
    	}
    	this._selectedIndex = index;
    	this._element.getChild(this._selectedIndex).getStyle().setProperty('visibility', 'visible');
    },
    onUpdate : function() {
        var cSize = this._element.getClientSize();
        var cWidth = cSize[0];
        var cHeight = cSize[1];
        var cStyle = this._element.getStyle();
        var hGap = cStyle.getPropertyValue('hGap') || 0;
        var vGap = cStyle.getPropertyValue('vGap') || 0;
        // TODO Only resize the selected child?
        var childCount = this._element.getChildCount();
        for (var i = 0; i < childCount; i++) {
            var child = this._element.getChild(i);
            //child.getStyle().setProperty('visibility', i == this._selectedIndex ? 'visible' : 'hidden');
            jls.gui.FlowLayout.place(child, hGap, vGap, cWidth - hGap * 2, cHeight - vGap * 2);
        }
    },
    onAddChild : function($super, child) {
        /*if (child.getStyle().getPropertyValue('visibility') == 'visible') {
            this.show(this._element.getChildCount() - 1);
            //this._selectedIndex = this._element.getChildCount() - 1;
        }*/
        child.getStyle().setProperty('visibility', ((this._element.getChildCount() - 1) == this._selectedIndex) ? 'visible' : 'hidden');
        $super(child);
    }
});
