jls.loader.provide('jls.html.HtmlElement');

jls.loader.require('jls.gui.Element');
jls.loader.require('jls.gui.Event');

jls.html.HtmlElement = jls.lang.Class.create(jls.gui.Element,
{
    initialize : function($super, parameters, parent) {
    	this._htmlElement = null;
    	this._htmlTagName = 'div';
        $super(parameters, parent);
        jls.logger.trace('parent: "' + parent + '"');
    },
    getHtmlElement : function() {
        return this._htmlElement;
    },
    setHtmlElement : function(element) {
        this._htmlElement = element;
        return this;
    },
    getHtmlTagName : function() {
        return this._htmlTagName;
    },
    setHtmlTagName : function(tagName) {
        this._htmlTagName = tagName;
        return this;
    },
    getTextContent : function() {
        if ((this._htmlElement != null) && (this._htmlElement.firstChild.nodeType == 3)) {
            return this._htmlElement.firstChild.nodeValue;
        }
        return '';
    },
    setTextContent : function(value) {
        if (this._htmlElement == null) {
            return this;
        }
        while (this._htmlElement.hasChildNodes()) {
            this._htmlElement.removeChild(this._htmlElement.firstChild);
        }
    	this._htmlElement.appendChild(document.createTextNode(value));
        return this;
    },
    onCreate : function() {
    	if (this._htmlElement == null) {
            this._htmlElement = document.createElement(this._htmlTagName);
    	}
    	if ((this.getParent() != null) && (this.getParent() instanceof jls.html.HtmlElement)) {
    		this.getParent()._htmlElement.appendChild(this._htmlElement);
    	}
    },
    onStyleChange : jls.lang.Class.emptyFunction,
    /*addChild : function($super, child) {
    	var child = $super(child);
    	if ((typeof child == 'object') && (child instanceof jls.html.HtmlElement)) {
            this._htmlElement.appendChild(child._htmlElement);
    	}
    	return child;
    },*/
    observe: function($super, type, handler) {
    	$super(type, handler);
    	this._htmlElement.addEventListener(type, (function(e) {
    		var event = new jls.gui.Event(e.type, e.target);
    		this.dispatch(event);
    	}).bind(this), false);
    },
    unobserve: function($super, type, handler) {
    	$super(type, handler);
    	this._htmlElement.removeEventListener(type, handler, false);
    	// TODO
    },
    onDestroy : jls.lang.Class.emptyFunction
});

/*Object.extend(jls.html.HtmlElement,
{
});*/

