jls.loader.provide('jls.io.OutputStreamWriter');

jls.loader.require('jls.io.cs.Charset');
jls.loader.require('jls.lang.CharBuffer');

jls.io.OutputStreamWriter = jls.lang.Class.create( /** @lends jls.io.OutputStreamWriter.prototype */
{
    /**
     * Creates a writer.
     * 
     * @param {jls.io.OutputStream} out The underlying byte output stream.
     * @param {String} csn The name of the character set to use.
     * @constructs
     * @class A character writer for byte output stream.
     */
    initialize : function(out, csn) {
        // TODO Check output stream
        this._out = out;
        var charset = csn ? jls.io.cs.Charset.forName(csn) : jls.io.cs.Charset.defaultCharset();
        this._encoder = charset.newEncoder();
    },
    getOutputStream : function() {
        return this._out;
    },
    close : function() {
        return this._out.close();
    },
    flush : function() {
        return this._out.flush();
    },
    writeChar : function(c) {
    	// TODO Change this
        return this.write(String.fromCharCode(c));
    },
    writeCharBuffer : function(cb) {
        var bb = this._encoder.encode(cb);
        bb.flip();
        return this._out.write(bb);
    },
    /**
     * Writes a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    write : function(s) {
        if (typeof s != 'string') {
            throw new jls.lang.Exception('Invalid argument');
        }
        var cb = jls.lang.CharBuffer.wrap(s);
        return this.writeCharBuffer(cb);
    },
    /**
     * Writes a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    writeLine : function(s) {
        if (s) {
            return this.write(s + jls.io.OutputStreamWriter.separator);
        } else {
            return this.write(jls.io.OutputStreamWriter.separator);
        }
    }
});

Object.extend(jls.io.OutputStreamWriter,
{
    separator : _native.core.properties['line.separator']
});

