jls.loader.provide('jls.io.cs.CharDecoder');

jls.loader.require('jls.lang.CharBuffer');

jls.io.cs.CharDecoder = jls.lang.Class.create( /** @lends jls.io.cs.CharDecoder.prototype */
{
    /**
     * Creates a character decoder.
     * 
     * @constructs
     * @class This class represents a character decoder.
     */
    initialize : function(charset) {
        this._charset = charset;
        this._averBytes = 1.0;
        this._replacement = '?'.charCodeAt(0);
    },
    /**
     * Decodes byte buffer and returns the character buffer.
     *
     * @param {jls.lang.Buffer} input The buffer to decode.
     * @returns {jls.lang.CharBuffer} The decoded character buffer.
     */
    decode : function(input, buffer) {
    	var length = Math.round(input.remaining() / this._averBytes);
    	var output = buffer || jls.lang.CharBuffer.allocate(length + 1, true);
    	while ((input.remaining() > 0) && (output.remaining() > 0)) {
    		var b = input.getByte();
    		if (b > 127) {
    			b = this._replacement;
    		}
    		output.putChar(b);
    	}
        return output;
    }
});

