jls.loader.provide('jls.io.cs.SingleByteDecoder');

jls.loader.require('jls.lang.CharBuffer');

jls.io.cs.SingleByteDecoder = jls.lang.Class.create( /** @lends jls.io.cs.SingleByteDecoder.prototype */
{
    /**
     * Creates a character decoder.
     * 
     * @constructs
     * @class This class represents a single byte character set decoder.
     */
    initialize : function(charset, mapping) {
        this._charset = charset;
        this._mapping = mapping;
        this._replacement = '?'.charCodeAt(0);
    },
    /**
     * Decodes byte buffer and returns the character buffer.
     *
     * @param {jls.lang.ByteBuffer} input The buffer to decode.
     * @param {jls.lang.CharBuffer} [buffer] The buffer to use.
     * @returns {jls.lang.CharBuffer} The decoded character buffer.
     */
    decode : function(input, buffer) {
    	var output = buffer || jls.lang.CharBuffer.allocate(input.remaining() + 1, true);
    	while ((input.remaining() > 0) && (output.remaining() > 0)) {
    		var b = input.getByte();
    		var c;
    		if (b in this._mapping) {
    			c = this._mapping[b];
    		} else {
    			c = this._replacement;
    		}
    		output.putChar(c);
    	}
        return output;
    }
});

