jls.loader.provide('jls.io.cs.SingleByteEncoder');

jls.loader.require('jls.lang.ByteBuffer');

jls.io.cs.SingleByteEncoder = jls.lang.Class.create( /** @lends jls.io.cs.SingleByteEncoder.prototype */
{
    /**
     * Creates a character encoder.
     * 
     * @constructs
     * @class This class represents a single byte character set encoder.
     */
    initialize : function(charset, mapping) {
        this._charset = charset;
        this._mapping = mapping;
        this._replacement = '?'.charCodeAt(0);
    },
    /**
     * Encodes a string and returns a buffer.
     *
     * @param {jls.lang.CharBuffer} input The character buffer to encode.
     * @param {jls.lang.ByteBuffer} [buffer] The buffer to use.
     * @returns {jls.lang.ByteBuffer} The encoded buffer.
     */
    encode : function(input, buffer) {
    	var output = buffer || jls.lang.ByteBuffer.allocate(input.remaining() + 1);
    	while ((input.remaining() > 0) && (output.remaining() > 0)) {
    		var c = input.getChar();
    		var b;
    		if (c in this._mapping) {
    			b = this._mapping[c];
    		} else {
    			b = this._replacement;
    		}
    		output.putByte(b);
    	}
        return output;
    }
});

Object.extend(jls.io.cs.SingleByteEncoder, /** @lends jls.io.cs.SingleByteEncoder */
{
    reverseMapping : function(byteToCharCode) {
    	var charCodeToByte = [];
    	for (var i = 0; i < 256; i++) {
    		var cc = byteToCharCode[i];
    		if (cc != null) {
    			charCodeToByte[cc] = i;
    		} else {
    			delete byteToCharCode[i];
    		}
    	}
    	return charCodeToByte;
    }
});