jls.loader.provide('jls.jsunit.Assert');

jls.loader.require('jls.lang.AssertionError');

/**
 * @class A set of assert methods. Messages are only displayed when an assert fails.
 */
jls.jsunit.Assert = jls.lang.Class.create({});

Object.extend(jls.jsunit.Assert, /** @lends jls.jsunit.Assert */
{
    /**
     * Fails a test with the given message.
     * 
     * @param {String} [message] The message associated with the failure.
     */
    fail : function(message) {
        throw new jls.lang.AssertionError(message);
    },
    failNotEquals : function(expected, actual, message) {
        var msg = (typeof message == 'string') ? (message + ' ') : '';
        jls.jsunit.Assert.fail(msg + 'expected:<' + expected + '> but was:<' + actual + '>');
    },
    failNotSame : function(expected, actual, message) {
        var msg = (typeof message == 'string') ? (message + ' ') : '';
        jls.jsunit.Assert.fail(msg + 'expected same:<' + expected + '> was not:<' + actual + '>');
    },
    failSame : function(message) {
        var msg = (typeof message == 'string') ? (message + ' ') : '';
        jls.jsunit.Assert.fail(msg + 'expected not same');
    },
    /**
     * Asserts that a condition is true.
     * 
     * @param {Boolean} condition The condition to verify.
     * @param {String} [message] The message associated with the assertion.
     */
    assertTrue : function(condition, message) {
        if (! condition) {
            jls.jsunit.Assert.fail(message);
        }
    },
    /**
     * Asserts that a condition is false.
     * 
     * @param {Boolean} condition The condition to verify.
     * @param {String} [message] The message associated with the assertion.
     */
    assertFalse : function(condition, message) {
        if (condition) {
            jls.jsunit.Assert.fail(message);
        }
    },
    /**
     * Asserts that a value is not null.
     * 
     * @param {Object} value The value to verify.
     * @param {String} [message] The message associated with the assertion.
     */
    assertNotNull : function(value, message) {
        if (value == null) {
            jls.jsunit.Assert.fail(message);
        }
    },
    /**
     * Asserts that two values differ.
     * 
     * @param {Object} expected The expected value.
     * @param {Object} actual The actual value.
     * @param {String} [message] The message associated with the assertion.
     */
    assertNotSame : function(expected, actual, message) {
        if (expected === actual) {
            jls.jsunit.Assert.failSame(message);
        }
    },
    /**
     * Asserts that a value is null.
     * 
     * @param {Object} value The value to verify.
     * @param {String} [message] The message associated with the assertion.
     */
    assertNull : function(value, message) {
        if (value != null) {
            jls.jsunit.Assert.fail(message);
        }
    },
    /**
     * Asserts that two values are the same.
     * 
     * @param {Object} expected The expected value.
     * @param {Object} actual The actual value.
     * @param {String} [message] The message associated with the assertion.
     */
    assertSame : function(expected, actual, message) {
        if (expected !== actual) {
            jls.jsunit.Assert.failNotSame(expected, actual, message);
        }
    },
    /**
     * Asserts that two values are equal.
     * 
     * @param {Object} expected The expected value.
     * @param {Object} actual The actual value.
     * @param {String} [message] The message associated with the assertion.
     */
    assertEquals : function(expected, actual, message) {
        if (expected != actual) {
            jls.jsunit.Assert.failNotEquals(expected, actual, message);
        }
    }
});
