//jls.loader.provide('jls.lang.ClassLoader');

/**
 * @class A class loader is an object that is responsible for loading classes.
 */
jls.lang.ClassLoader = jls.lang.Class.create(/** @lends jls.lang.ClassLoader.prototype */
{
    initialize : function() {
        this._cache = {};
        this._loadedLibraries = {};
    },
    /**
     * Loads a native library compliant with the JLS native engine.
     * 
     * @param {String} name The name of the library to load.
     */
    requireLibrary : function(libname) {
        if (libname in this._loadedLibraries) {
            return;
        }
        try {
            _native.core.loadLibrary(libname);
            this._loadedLibraries[libname] = true;
        } catch (e) {
            throw e;
        }
    },
    /**
     * Declares that a class is about to be provided.
     * 
     * @param {String} classname The classname that is provided.
     */
    provide : function(classname, exists) {
        if (classname in this._cache) {
            //throw new jls.lang.Exception('Class ' + classname + ' already provided.');
            jls.logger.warn('Class ' + classname + ' already provided.');
            return;
        }
        jls.lang.ClassLoader.createPackage(classname);
        jls.logger.debug('provide(\"' + classname + '\")');
        if (exists) {
            this._cache[classname] = eval(classname);
        } else {
            this._cache[classname] = true; // in progress
            jls.logger.debug(classname + ' providing in progress');
        }
    },
    /**
     * Declares a class requirement. If that class has not yet been provided then it is loaded.
     * 
     * @param {String} classname The classname that is required.
     */
    require : function(classname) {
        if (classname in this._cache) {
            if (this._cache[classname] === true) {
                //jls.logger.warn('class \"' + classname + '\" provided but not yet created');
                return null;
            }
            return this._cache[classname];
        }
        var path = jls.lang.ClassLoader.getClassFilename(classname, '.js');
        jls.logger.debug('Loading class \"' + classname + '\", evalScript: \"' + path + '\"');
        _native.core.evalScript(path);
        if (! (classname in this._cache)) {
            throw new jls.lang.Exception('class not provided ' + classname);
        } else {
            jls.logger.debug('class ' + classname + ' provided');
        }
        this._cache[classname] = eval(classname);
        return this._cache[classname];
    },
    getClass : function(name) {
        for (var name in this._cache) {
            return this._cache[name];
        }
        return null;
    },
    getClassname : function(obj) {
        for (var name in this._cache) {
            if (this._cache[name] === obj.constructor) {
                return name;
            }
        }
        return null;
    },
    // TODO Find the right place for this method
    // fn must be function(name)
    visitPaths : function(fn) {
        _native.core.visitPaths(fn);
    }
});

Object.extend(jls.lang.ClassLoader, /** @lends jls.lang.ClassLoader */
{
    getClassFilename : function(name, extension) {
        return name.replace(/\./g, '/') + extension;
    },
    createPackage : function(packagename) {
        var packagenames = packagename.split('.');
        var name = '';
        for (var i = 0; i < packagenames.length - 1; i++) {
            if (i > 0) {
                name += '.';
            }
            name += packagenames[i];
            var packagetype = eval('typeof ' + name);
            //jls.logger.debug('Package \"' + name + '\": ' + packagetype);
            if (packagetype == 'undefined') {
                eval(name + ' = {};');
            } else if (packagetype != 'object') {
                throw new jls.lang.Exception('Invalid package \"' + packagename + '\".');
            }
        }
    }
});
