jls.loader.provide('jls.gui.Event');

jls.gui.Event = jls.lang.Class.create( /** @lends jls.gui.Event.prototype */
{
    //bubbles:  	Returns a Boolean value that indicates whether or not an event is a bubbling event
    //cancelable: 	Returns a Boolean value that indicates whether or not an event can have its default action prevented
    //currentTarget: 	Returns the element whose event listeners triggered the event
    //eventPhase: 	Returns which phase of the event flow is currently being evaluated
    /**
     * Creates an event.
     * 
     * @param {String} type The event type.
     * @constructs
	 * @class This class represents a graphical event.
     */
    initialize : function(type, target) {
        this.type = type;
        this.target = target;
        this.timeStamp = 0;
    },
    //relatedTarget: 	Returns the element related to the element that triggered the event
    setMouse : function(button, clientX, clientY, screenX, screenY) {
        this.button = button;
        this.clientX = clientX;
        this.clientY = clientY;
        this.screenX = screenX;
        this.screenY = screenY;
        return this;
    },
    setKeyModifiers : function(altKey, ctrlKey, metaKey, shiftKey) {
        this.altKey = altKey;
        this.ctrlKey = ctrlKey;
        this.metaKey = metaKey;
        this.shiftKey = shiftKey;
        return this;
    },
    // Internet Explorer uses event.keyCode to retrieve the character that was pressed and Netscape/Firefox/Opera uses event.which
    setKey : function(which) {
        this.which = which;
        return this;
    },
    stopPropagation : function() {
        return this;
    },
    preventDefault : function() {
        return this;
    }
});

Object.extend(jls.gui.Event, /** @lends jls.gui.Event */
{
    MOUSE_BUTTON_LEFT : 0,
    MOUSE_BUTTON_MIDDLE : 1,
    MOUSE_BUTTON_RIGHT : 2,
    createMouseEvent : function(type, target, button, clientX, clientY, screenX, screenY) {
        var event = new jls.gui.Event(type, target);
        event.setMouse(button, clientX, clientY, screenX, screenY);
        return event;
    },
    createKeyEvent : function(type, target, which) {
        var event = new jls.gui.Event(type, target);
        event.setKey(which);
        return event;
    }
});

