jls.loader.provide('jls.io.FileChannel');

jls.loader.require('jls.io.FileDescriptor');

jls.io.FileChannel = jls.lang.Class.create(jls.io.FileDescriptor, /** @lends jls.io.FileChannel.prototype */
{
    /**
     * Creates a file channel.
     * 
     * @param {jls.io.File} file The file.
     * @param {Number} [flags] The file flags.
     * @augments jls.io.FileDescriptor
     * @class This class represents a file channel.
     * @constructs
     */
    initialize : function($super, file, flags) {
        var nfd = null;
        flags = flags || jls.io.FileChannel.READ_ONLY;
        if ((file instanceof _native.io.FileDesc) || (file instanceof _native.io.StaticFileDesc)) {
        	nfd = file;
        } else if (file instanceof jls.io.File) {
        	nfd = new _native.io.FileDesc(file.getPath(), flags);
        } else if (typeof file == 'string') {
        	nfd = new _native.io.FileDesc(file, flags);
        } else {
            throw new jls.lang.Exception('Invalid file type');
        }
        if (nfd == null) {
            throw new jls.lang.Exception('File not found');
        }
        $super(nfd);
    }
});

Object.extend(jls.io.FileChannel, /** @lends jls.io.FileChannel */
{
    READ_ONLY : _native.io.FileDesc.READ_ONLY,
    WRITE_ONLY : _native.io.FileDesc.WRITE_ONLY,
    READ_WRITE : _native.io.FileDesc.READ_WRITE,
    CREATE_FILE : _native.io.FileDesc.CREATE_FILE,
    APPEND : _native.io.FileDesc.APPEND,
    TRUNCATE : _native.io.FileDesc.TRUNCATE,
    SYNC : _native.io.FileDesc.SYNC,
    EXCL : _native.io.FileDesc.EXCL
});

