jls.loader.provide('jls.io.FileInputStream');

jls.loader.require('jls.io.FileChannel');

jls.io.FileInputStream = jls.lang.Class.create(jls.io.FileChannel, /** @lends jls.io.FileInputStream.prototype */
{
    /**
     * Creates a file input stream.
     * 
     * @param {jls.io.File} file The file.
     * @constructs
     * @augments jls.io.FileChannel
     * @class This class represents a file input stream.
     */
    initialize : function($super, file) {
        var flags = _native.io.FileDesc.READ_ONLY;
        $super(file, flags);
    },
    write : jls.lang.Class.notAvailableFunction,
    writeByte : jls.lang.Class.notAvailableFunction,
    writeByteArray : jls.lang.Class.notAvailableFunction
});

