jls.loader.provide('jls.io.FileOutputStream');

jls.loader.require('jls.io.FileChannel');

jls.io.FileOutputStream = jls.lang.Class.create(jls.io.FileChannel, /** @lends jls.io.FileOutputStream.prototype */
{
    /**
     * Creates a file output stream.
     * 
     * @param {jls.io.File} file The file.
     * @param {Boolean} [append] The append flags.
     * @constructs
     * @augments jls.io.FileChannel
     * @class This class represents a file output stream.
     */
    initialize : function($super, file, append) {
        var flags = _native.io.FileDesc.WRITE_ONLY | _native.io.FileDesc.CREATE_FILE | (append ? _native.io.FileDesc.APPEND : _native.io.FileDesc.TRUNCATE);
        $super(file, flags);
    },
    read : jls.lang.Class.notAvailableFunction,
    readByte : jls.lang.Class.notAvailableFunction,
    readByteArray : jls.lang.Class.notAvailableFunction
});

