jls.loader.provide('jls.io.Pipe');

jls.loader.requireLibrary('jls_io');

jls.loader.require('jls.io.FileDescriptor');

jls.io.Pipe = jls.lang.Class.create( /** @lends jls.io.Pipe.prototype */
{
    /**
     * Creates a pipe.
     * 
     * @constructs
     * @class This class represents a pipe.
     */
    initialize : function() {
        var pipe = _native.io.createPipe();
        this._sink = new jls.io.FileDescriptor(pipe[0]);
        this._source = new jls.io.FileDescriptor(pipe[1]);
    },
    /**
     * Returns the sink file descriptor.
     *
     * @returns {jls.io.FileDescriptor} The sink.
     */
    sink : function() {
        return this._sink;
    },
    /**
     * Returns the source file descriptor.
     *
     * @returns {jls.io.FileDescriptor} The source.
     */
    source : function() {
        return this._source;
    },
    /**
     * Closes the pipe.
     *
     */
    close : function() {
        this._sink.close();
        this._source.close();
    }
});


Object.extend(jls.io.Pipe, /** @lends jls.io.Pipe */
{
    /**
     * Opens a pipe.
     * 
     * @returns {jls.io.Pipe} The new pipe.
     */
    open : function() {
        return new jls.io.Pipe();
    }
});

