jls.loader.provide('jls.io.PrintStream');

jls.loader.require('jls.io.File');
jls.loader.require('jls.io.OutputStreamWriter');
jls.loader.require('jls.io.FileChannel');
jls.loader.require('jls.io.FileOutputStream');

jls.io.PrintStream = jls.lang.Class.create(jls.io.OutputStreamWriter, /** @lends jls.io.PrintStream.prototype */
{
    /**
     * Creates a print stream.
     * 
     * @param {jls.io.OutputStream} out The underlying byte output stream or a file, a filename.
     * @param {String} csn The name of the character set to use.
     * @constructs
     * @augments jls.io.OutputStreamWriter
     * @class A print stream.
     */
    initialize : function($super, out, csn) {
        // if out is jls.io.FileChannel then jls.io.FileChannel is provided
        if ((out instanceof jls.io.FileChannel) || (out instanceof jls.io.FileOutputStream)) {
            // nothing to do
        } else if ((out instanceof jls.io.File) || (typeof out == 'string')) {
            out = new jls.io.FileOutputStream(out);
        } else if ((out instanceof _native.io.FileDesc) || (out instanceof _native.io.StaticFileDesc)) {
            out = new jls.io.FileChannel(out);
        } else {
            throw new jls.lang.Exception('Invalid outputstream');
        }
        $super(out, csn);
    },
    /**
     * Prints a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    print : function(s) {
        return this.write(s);
    },
    /**
     * Prints a string.
     *
     * @param {String} s The string to write.
     * @returns {Number} the write byte count.
     */
    println : function(s) {
        return this.writeLine(s);
    }
});
