jls.loader.provide('jls.io.cs.CharEncoder');

jls.loader.require('jls.lang.ByteBuffer');

jls.io.cs.CharEncoder = jls.lang.Class.create( /** @lends jls.io.cs.CharEncoder.prototype */
{
    /**
     * Creates a character encoder.
     * 
     * @constructs
     * @param {jls.io.cs.Charset} charset The related charset.
     * @class This class represents a character encoder.
     */
    initialize : function(charset) {
        this._charset = charset;
        this._averBytes = 1.0;
        this._replacement = '?'.charCodeAt(0);
    },
    /**
     * Encodes a string and returns a buffer.
     *
     * @param {jls.lang.CharBuffer} input The character buffer to encode.
     * @returns {jls.lang.Buffer} The encoded buffer.
     */
    encode : function(input, buffer) {
    	var length = Math.round(input.remaining() * this._averBytes);
    	var output = buffer || jls.lang.ByteBuffer.allocate(length + 1);
        jls.logger.debug('CharEncoder.encode(), length: ' + length + ', output.remaining(): ' + output.remaining());
    	while (input.remaining() > 0) {
    		var c = input.getChar();
    		if (c > 127) {
    			c = this._replacement;
    		}
    		output.putByte(c);
    	}
        return output;
    }
});

