jls.loader.provide('jls.jsunit.TestCase');

jls.loader.require('jls.lang.AssertionError');
jls.loader.require('jls.jsunit.TestResult');
jls.loader.require('jls.jsunit.Assert');

/**
 * @namespace Provides JSUnit core classes.
 * @see jls.jsunit.TestCase
 * @name jls.jsunit
 */

jls.jsunit.TestCase = jls.lang.Class.create( /** @lends jls.jsunit.TestCase.prototype */
{
    /**
     * Constructs a test case with the given name.
     *
     * @param {String} name The name of the test case.
     * @class A test case defines the fixture to run multiple tests.
     * The test cases can be launched by using the jls.jsunit.TestRunner class.
     * @constructs
     */
    initialize : function(name) {
        this.setName(name);
    },
    /**
     * Sets this test case name.
     * 
     * @param {String} name The name of the test case.
     * @returns {jls.jsunit.TestCase} This test case.
     */
    setName : function(name) {
        this._name = name || '';
    },
    /**
     * Returns this test case name.
     * 
     * @returns {String} The name of the test case.
     */
    getName : function() {
        return this._name;
    },
    /**
     * Sets up the fixture. This method is called before a test is executed.
     * 
     */
    setUp : function() {
    },
    /**
     * Tears down the fixture. This method is called after a test is executed.
     * 
     */
    tearDown : function() {
    },
    /**
     * Returns the test case count.
     * 
     * @returns {Number} The test case count.
     */
    countTestCases : function() {
        return 1;
    },
    runBare : function() {
        var exception = null;
		this.setUp();
        try {
            this.runTest();
        }
        catch (e) {
			exception = e;
        }
        try {
            this.tearDown();
        }
        catch (e) {
            if (exception == null) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    },
    /**
     * Override to run the test and assert its state.
     */
    runTest : function() {
        jls.jsunit.Assert.assertNotNull(this.getName(), 'TestCase.name cannot be null');
        jls.jsunit.Assert.assertTrue((this.getName() in this) && (typeof this[this.getName()] == 'function'), 'Function "' + this.getName() + '" not found');
        this[this.getName()]();
    }
});

