jls.loader.provide('jls.jsunit.TestRunner');

jls.loader.require('jls.lang.AssertionError');
jls.loader.require('jls.jsunit.TestCase');
jls.loader.require('jls.jsunit.TestResult');
jls.loader.require('jls.jsunit.TestSuite');

jls.jsunit.TestRunner = jls.lang.Class.create({});

Object.extend(jls.jsunit.TestRunner,
{
    isTest : function(name) {
        var found = name.match(/([A-Z][^\/]+Test)\.js$/);
        return found && found.length > 0;
    },
    getClassname : function(name) {
        return name.substr(0, name.length - 3).replace(/\//g, '.');
    },
    printUsage : function() {
        jls.lang.System.err.println('Usage: jls jls.jsunit.TestRunner [-help|-all|-list|-gc|-verbose] classnames...');
    },
    main : function(args) {
        /*
         * use jls.loader.visitPaths to find test classes
         * test with jls.test.Struct
         */
        if (args <= 0) {
            jls.jsunit.TestRunner.printUsage();
            jls.lang.Runtime.exit(22);
        }
        var tr = new jls.jsunit.TestRunner.TestResultDeco();
        var ts = new jls.jsunit.TestSuite();
        
        for (var i = 0; i < args.length; i++) {
            switch (args[i]) {
            case '-all':
                // Add all tests
                //jls.lang.System.out.println('Running all tests...');
                jls.loader.visitPaths(function(name) {
                    if (jls.jsunit.TestRunner.isTest(name)) {
                        var classname = jls.jsunit.TestRunner.getClassname(name);
                        //jls.lang.System.out.println('\t' + classname);
                        ts.addTestSuite(classname);
                    }
                    return true;
                });
                break;
            case '-list':
                jls.lang.System.out.println('Available tests:');
                jls.loader.visitPaths(function(name) {
                    if (jls.jsunit.TestRunner.isTest(name)) {
                        jls.lang.System.out.println('\t' + jls.jsunit.TestRunner.getClassname(name));
                    }
                    return true;
                });
                jls.lang.System.exit(0);
                break;
            case '-help':
                jls.jsunit.TestRunner.printUsage();
                jls.lang.Runtime.exit(0);
                break;
            case '-gc':
                tr.setGC(true);
                break;
            case '-verbose':
                tr.setVerbose(true);
                break;
            default:
                ts.addTestSuite(args[i]);
                break;
            }
        }
        if (ts.testCount() == 0) {
            jls.jsunit.TestRunner.printUsage();
            jls.lang.Runtime.exit(22);
        }
        ts.run(tr);
        //jls.lang.System.out.println(tr.toString());
        tr.print();
    }
});

jls.jsunit.TestRunner.TestResultDeco = jls.lang.Class.create(jls.jsunit.TestResult,
{
    initialize : function($super) {
        $super();
		this._verbose = false;
		this._gc = false;
    },
    setVerbose : function(value) {
		this._verbose = value;
    },
    setGC : function(value) {
		this._gc = value;
    },
    startTest : function($super, test) {
        $super(test);
        if (this._verbose) {
            jls.lang.System.out.println('Running: ' + jls.loader.getClassname(test) + '.' + test.getName() + '()');
        }
    },
    endTest : function($super, test) {
        $super(test);
        if (this._gc) {
            jls.lang.Runtime.gc();
        }
    },
    addFailure : function($super, test, e) {
        $super(test, e);
        if (this._verbose) {
            jls.lang.System.out.println('Test: ' + jls.loader.getClassname(test) + '.' + test.getName() + '() failed due to "' + e.getMessage() + '"');
        }
    },
    addError : function($super, test, e) {
        $super(test, e);
        if (this._verbose) {
            jls.lang.System.out.println('Test: ' + jls.loader.getClassname(test) + '.' + test.getName() + '() in error due to:');
            jls.lang.Exception.wrap(e).printStackTrace(jls.lang.System.out);
        }
    },
    print : function(ps) {
        ps = ps || jls.lang.System.out;
        ps.println(this.toString());
        for (var i = 0; i < this.getErrors().length; i++) {
            var tf = this.getErrors()[i];
            var tfe = tf.thrownException();
            ps.println('Test "' + tf.failedTest().getName() + '" in error due to:');
			jls.lang.Exception.wrap(tfe).printStackTrace(ps);
        }
        for (var i = 0; i < this.getFailures().length; i++) {
            var tf = this.getFailures()[i];
            ps.println('Test "' + tf.failedTest().getName() + '" failed due to "' + tf.thrownException().getMessage() + '"');
        }
    }
});

