jls.loader.provide('jls.lang.Lock');

jls.lang.Lock = jls.lang.Class.create(/** @lends jls.lang.Lock.prototype */
{
    /**
     * Creates a lock. A lock provides a means to control access to a shared resource by multiple threads.
     *
     * @constructs
     * @class A lock provides a means to control access to a shared resource by multiple threads.
     * Locking prevents access to some resource, such as a piece of shared data: that is, it enforces mutual exclusion.
     */
    initialize : function() {
        this._no = new _native.core.Lock();
    },
    /**
     * Closes this lock.
     * 
     * @returns {jls.lang.Lock} This lock.
     */
    close : function() {
        this._no.close();
        return this;
    },
    /**
     * Acquires the lock.
     * 
     * @returns {jls.lang.Lock} This lock.
     */
    lock : function() {
        this._no.lock();
        return this;
    },
    /**
     * Releases the lock.
     * 
     * @returns {jls.lang.Lock} This lock.
     */
    unlock : function() {
        this._no.unlock();
        return this;
    }
});

