jls.loader.provide('jls.lang.ModuleLoader');

/*
 * for /f %d in ('dir /b ..\res\cjsunit') do jls -Djls.enableCommonJSModule -sp ..\res\cjsunit\%d program.js
 */

/**
 * @class A module loader is an object that is responsible for loading Common JS modules.
 * The ModuleLoader class implements the CommonJS Modules 1.0 specification.
 */
jls.lang.ModuleLoader = jls.lang.Class.create(/** @lends jls.lang.ModuleLoader.prototype */
{
    // private
    initialize : function() {
        this._cache = {};
        this._path = '.';
        this._commonJSEnabled = ('jls.enableCommonJSModule' in _native.core.properties);
    },
    /**
     * Returns the exported API of the foreign module.
     * 
     * @param {String} path The path of the module to load.
     */
    require : function(path) {
        // Find out the absolute path that is used as unique id
        var pathItems = path.split('/');
        if ((this._path != '.') && ((pathItems[0] == '.') || (pathItems[0] == '..'))) {
            pathItems = this._path.split('/').concat(pathItems);
        }
        for (var i = 0; i < pathItems.length; i++) {
            if (pathItems[i] == '.') {
                pathItems.splice(i, 1);
                i--;
                continue;
            }
            if (pathItems[i] == '..') {
                if (i == 0) {
                    throw new jls.lang.Exception('Invalid path');
                }
                pathItems.splice(i - 1, 1);
                i -= 2;
                continue;
            }
        }
        var absPath = pathItems.join('/');
        if (absPath in this._cache) {
            return this._cache[absPath];
        }
        // We have to create the object before evaluating the module in case of cyclic dependency.
        var exports = {};
        // We have to keep our path for relative requires
        var previousPath = this._path;
        try {
            if (pathItems.length > 1) {
                pathItems.splice(pathItems.length - 1, 1);
                this._path = pathItems.join('/');
            } else {
                this._path = '.';
            }
            // TODO Remove
            //jls.logger.warn('require("' + path + '") previousPath: ' + previousPath + ', path: ' + this._path + ', absPath: ' + absPath);
            this._cache[absPath] = exports;
            var rsrcStr = _native.core.getResourceAsString(absPath + '.js');
            var evalSrc = 'function (exports) { ';
            if (! this._commonJSEnabled) {
                // Add require in the scope
                evalSrc += 'var require = jls.lang.ModuleLoader.getInstance().require.bind(jls.lang.ModuleLoader.getInstance()); ';
            }
            evalSrc += rsrcStr;
            evalSrc += ' }';
            var fn = eval(evalSrc);
            fn(exports);
        }
        catch (e) {
            // remove entry as something goes wrong
            delete this._cache[absPath];
            throw e; // rethrow
        }
        finally {
            // Restore previous path
            this._path = previousPath;
        }
        return exports;
    }
});

Object.extend(jls.lang.ModuleLoader, /** @lends jls.lang.ModuleLoader */
{
    _instance : null,
    /**
     * Gets the current module loader instance.
     * 
     * @returns {jls.lang.ModuleLoader} The module loader instance.
     */
    getInstance : function() {
        if (jls.lang.ModuleLoader._instance == null) {
            jls.lang.ModuleLoader._instance = new jls.lang.ModuleLoader();
        }
        return jls.lang.ModuleLoader._instance;
    }
});

