jls.loader.provide('jls.lang.Monitor');

jls.lang.Monitor = jls.lang.Class.create(/** @lends jls.lang.Monitor.prototype */
{
    /**
     * Creates a monitor. A monitor provides a means to synchronize threads.
     *
     * @constructs
     * @class A monitor provides a means to synchronize threads.
     * Notification involves passing synchronization information among cooperating threads.
     */
    initialize : function() {
        this._no = new _native.core.Monitor();
    },
    /**
     * Closes this monitor.
     * 
     * @returns {jls.lang.Monitor} This monitor.
     */
    close : function() {
        this._no.close();
        return this;
    },
    /*
     * Enters the monitor.
     * 
     * @returns {jls.lang.Monitor} This monitor.
     */
    /* enter : function() {
        this._no.enter();
        return this;
    }, */
    /*
     * Exits the monitor.
     * 
     * @returns {jls.lang.Monitor} This monitor.
     */
    /* exit : function() {
        this._no.exit();
        return this;
    }, */
    /**
     * Causes the current thread to wait until another thread invokes the notify method of this monitor.
     * 
     * @param {Number} [timeout] The maximum time to wait in milliseconds.
     * @returns {jls.lang.Monitor} This monitor.
     */
    wait : function(timeout) {
        this._no.enter();
        this._no.wait(timeout || -1);
        this._no.exit();
        return this;
    },
    /**
     * Wakes up a single thread that is waiting on this monitor.
     * 
     * @returns {jls.lang.Monitor} This monitor.
     */
    notify : function() {
        this._no.enter();
        this._no.notify();
        this._no.exit();
        return this;
    }
});

