jls.loader.provide('jls.lang.Signal');

jls.loader.require('jls.lang.Thread');
jls.loader.require('jls.lang.Monitor');

/**
 * @class This class provides signal support.
 * @see jls.lang.Monitor
 * @see jls.lang.Thread
 */
jls.lang.Signal = jls.lang.Class.create({});

Object.extend(jls.lang.Signal, /** @lends jls.lang.Signal */
{
    _handlers : [],
    _thread : null,
    _sigMon : null,
    _startSignalThread : function() {
        if (jls.lang.Signal._thread != null) {
            return;
        }
        jls.lang.Signal._sigMon = new jls.lang.Monitor();
        _native.core.registerSignalMonitor(jls.lang.Signal._sigMon._no);
        jls.lang.Signal._thread = new jls.lang.Thread(true);
        jls.lang.Signal._thread.run = function() {
            for (;;) {
                jls.lang.Signal._sigMon.wait();
                var signalCounters = _native.core.getSignalCounters();
                for (var sig = 0; sig < signalCounters.length; sig++) {
                    for (var i = 0; i < signalCounters[sig]; i++) {
                        _native.core.handleSignal(sig);
                        if (jls.lang.Signal._handlers[sig]) {
                            try {
                                jls.lang.Signal._handlers[sig]();
                            }
                            catch (e) {
                                jls.logger.warn('Unexpected exception while handling signal ' + sig + ': ' + e);
                            }
                        }
                    }
                }
            }
        }
        jls.logger.debug('Start signal thread');
        jls.lang.Signal._thread.start();
        jls.logger.debug('Signal thread Started');
    },
    SIGINT : _native.core.SIGINT, // Ctrl-C
    SIGILL : _native.core.SIGILL,
    SIGFPE : _native.core.SIGFPE,
    SIGSEGV : _native.core.SIGSEGV,
    SIGTERM : _native.core.SIGTERM,
    SIGBREAK : _native.core.SIGBREAK, // Ctrl-Break
    SIGABRT : _native.core.SIGABRT,
    /**
     * Registers a signal handler.
     * 
     * @param {Number} sig The signal number to be handled.
     * @param {Function} [handler] The handler to be registered with the given signal.
     * @returns {Function} The previous hanlder if any.
     */
    handle : function(sig, handler) {
        handler = handler || null;
        var sigHandler = (handler == null) ? _native.core.SIG_DFL : _native.core.SIG_USR;
        _native.core.signal(sig, sigHandler);
        var previousHandler = jls.lang.Signal._handlers[sig];
        jls.lang.Signal._handlers[sig] = handler;
        jls.lang.Signal._startSignalThread();
        return previousHandler;
    },
    /**
     * Raises a signal.
     * 
     * @param {Number} sig The signal number to be handled.
     */
    raise : function(sig) {
        _native.core.raise(sig);
    }
});

