jls.loader.provide('jls.lang.Thread');

jls.lang.Thread = jls.lang.Class.create( /** @lends jls.lang.Thread.prototype */
{
    /**
     * Creates a thread.
     *
     * @param {Boolean} [daemon] The thread is a daemon.
     * @param {Boolean} [shared] Whether the thread to create shares the current context.
     * @constructs
     * @class This class represents a thread. Each thread is an execution entity that is
     * scheduled independently from other threads in the same process.
     * @see jls.lang.Monitor
     * @see jls.lang.Lock
     */
    initialize : function(daemon, shared) {
        this._thread = new _native.core.Thread(daemon || false, typeof shared == 'boolean' ? shared : true);
    },
    /**
     * Closes this thread.
     * 
     * @returns {jls.lang.Thread} This thread.
     */
    close : function() {
        this._thread.close();
        return this;
    },
    /**
     * This method should be overriden, it is called in the thread.
     */
    run : function() {
        // to be overriden
    },
    /**
     * Starts this thread.
     * 
     * @param {Object} [thisArg] The object to use as this when running this thread.
     * @returns {jls.lang.Thread} This thread.
     */
    start : function(thisArg) {
        if (thisArg && (typeof thisArg == 'object')) {
            // TODO make it native ?
            this._thread.start(this.run.bind(thisArg));
        } else {
            this._thread.start(this.run);
        }
        return this;
    },
    /**
     * Joins this thread.
     * 
     * @returns {jls.lang.Thread} This thread.
     */
    join : function() {
        this._thread.join();
        return this;
    }
});

Object.extend(jls.lang.Thread, /** @lends jls.lang.Thread */
{
    /**
     * Causes the currently executing thread to sleep.
     * 
     * @param {Number} [ms] The length of time to sleep in milliseconds.
     */
    sleep : function(ms) {
        _native.core.sleep(ms || 0);
    }
});

