jls.loader.provide('jls.net.BufferSelectionHandler');

jls.loader.require('jls.net.SelectionHandler');
jls.loader.require('jls.lang.ByteBuffer');
/*
 * TODO Allow read until string or byte array
 */
jls.net.BufferSelectionHandler = jls.lang.Class.create(jls.net.SelectionHandler, /** @lends jls.net.BufferSelectionHandler.prototype */
{
    /**
     * Creates a buffer selection handler.
     *
     * @param {jls.lang.Buffer} buffer The buffer to use.
     * @constructs
	 * @augments jls.net.SelectionHandler
	 * @class A selection handler for reading and writing a buffer.
     */
    initialize : function(buffer) {
        if (! (buffer instanceof jls.lang.Buffer)) {
            throw new jls.lang.Exception('Invalid buffer argument type (' + (typeof buffer) + ')');
        }
        this._buffer = buffer.slice();
    },
    buffer : function() {
        return this._buffer;
    },
    length : function() {
        return this._buffer.capacity();
    },
    reset : function() {
        this._buffer.clear();
        return this;
    },
    canRead : function() {
        return true;
    },
    canWrite : function() {
        return true;
    },
    onSelect : function(op, channel) {
        //jls.logger.info('BufferSelectionHandler.onSelect(' + op + ')' + ', remaining: ' + this._buffer.remaining() + '/' + this._buffer.capacity());
        if (this._buffer.remaining() == 0) {
            return jls.net.SelectionHandler.STATUS_DONE;
        }
        if (channel[op](this._buffer) < 0) {
            return jls.net.SelectionHandler.STATUS_FAILURE;
        }
        return this._buffer.remaining() == 0 ? jls.net.SelectionHandler.STATUS_DONE : jls.net.SelectionHandler.STATUS_IN_PROGRESS;
    },
    onRead : function(channel) {
        return this.onSelect(jls.net.SelectionHandler.OP_READ, channel);
    },
    onWrite : function(channel) {
        return this.onSelect(jls.net.SelectionHandler.OP_WRITE, channel);
    }
});

