jls.loader.provide('jls.net.FileSelectionHandler');

jls.loader.require('jls.net.SelectionHandler');
jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileChannel');
jls.loader.require('jls.lang.ByteBuffer');

jls.net.FileSelectionHandler = jls.lang.Class.create(jls.net.SelectionHandler, /** @lends jls.net.FileSelectionHandler.prototype */
{
    /**
     * Creates a file selection handler.
     *
     * @param {jls.io.File} file The file to use.
     * @constructs
	 * @augments jls.net.SelectionHandler
	 * @class A selection handler for reading and writing a file.
     */
    initialize : function(file, length) {
        if (! (file instanceof jls.io.File)) {
            throw new jls.lang.Exception('Invalid file argument type (' + (typeof file) + ')');
        }
        this._file = file;
        this._fc = null;
        this._buffer = jls.lang.ByteBuffer.allocate(1024);
        this._length = length || this._file.length();
    },
    length : function() {
        return this._length;
    },
    reset : function() {
        this._remaining = this._length;
        this._buffer.clear();
        this._buffer.setLimit(0);
        if (this._fc != null) {
            this._fc.close();
            this._fc = null;
        }
    },
    onRead : function(channel) {
        var noDataStatus = jls.net.SelectionHandler.STATUS_FAILURE;
        for (;;) {
            this._buffer.clear();
            var count = channel.read(this._buffer);
            if (count <= 0) {
                return noDataStatus;
            }
            this._buffer.flip();
            this._remaining -= this._buffer.remaining();
            noDataStatus = jls.net.SelectionHandler.STATUS_IN_PROGRESS;
            if (this._fc == null) {
                this._fc = new jls.io.FileChannel(this._file, jls.io.FileChannel.WRITE_ONLY | jls.io.FileChannel.CREATE_FILE);
            }
            this._fc.write(this._buffer);
            if (this._remaining == 0) {
                this.reset();
                return jls.net.SelectionHandler.STATUS_DONE;
            }
        }
    },
    onWrite : function(channel) {
        var noDataStatus = jls.net.SelectionHandler.STATUS_FAILURE;
        for (;;) {
            if (this._buffer.remaining() > 0) {
                if (channel.write(this._buffer) <= 0) {
                    return noDataStatus;
                }
                if (this._buffer.remaining() > 0) {
                    return jls.net.SelectionHandler.STATUS_IN_PROGRESS;
                }
                noDataStatus = jls.net.SelectionHandler.STATUS_IN_PROGRESS;
            }
            if (this._remaining == 0) {
                this.reset();
                return jls.net.SelectionHandler.STATUS_DONE;
            }
            if (this._fc == null) {
                this._fc = new jls.io.FileChannel(this._file, jls.io.FileChannel.READ_ONLY);
            }
            this._buffer.clear();
            var count = this._fc.read(this._buffer);
            if (count > 0) {
                this._remaining -= count;
            }
            if (this._remaining == 0) {
                this._fc.close();
                this._fc = null;
            }
            this._buffer.flip();
        }
    }
});
