jls.loader.provide('jls.net.InetAddress');

jls.loader.requireLibrary('jls_net');

/**
 * @class This class represents an Internet Protocol (IP) address.
 */
jls.net.InetAddress = jls.lang.Class.create( /** @lends jls.net.InetAddress.prototype */
{
    initialize : function(ip) {
        this._ip = ip;
        this._name = null;
    },
    /**
     * Returns the raw IP address of this InetAddress object. The result is in network byte order: the highest order byte of the address is in getAddress()[0].
     * 
     * @returns {Array} The raw IP address of this object.
     */
    getAddress : function() {
        return [];
    },
    /**
     * Returns the IP address string in textual presentation.
     * 
     * @returns {String} The raw IP address in a string format.
     */
    getHostAddress : function() {
        return this._ip;
    },
    /**
     * Gets the host name for this IP address.
     * 
     * @returns {String} The host name for this IP address.
     */
    getHostName : function() {
        if (this._name == null) {
            this._name = _native.net.getHostName(this._ip);
        }
        return this._name;
    }
});

Object.extend(jls.net.InetAddress,
{
    /**
     * Given the name of a host, returns an array of InetAddress.
     * 
     * @param {String} name The host name or address to lookup.
     * @returns {Array} An array of its IP addresses.
     */
    getAllByName : function(name) {
        var result = [];
        var all = _native.net.getAllByName(name);
        for (var i = 0; i < all.length; i++) {
            result.push(new jls.net.InetAddress(all[i]));
        }
        return result;
    },
    /**
     * Given the address of a host, returns the InetAddress.
     * 
     * @param {String} addr The address to lookup.
     * @returns {jls.net.InetAddress} The InetAddress object.
     */
    getByAddress : function(addr) {
        return new jls.net.InetAddress(addr);
    },
    /**
     * Given the name of a host, returns the InetAddress.
     * 
     * @param {String} name The host name or address to lookup.
     * @returns {jls.net.InetAddress} The InetAddress object.
     */
    getByName : function(name) {
        var all = _native.net.getAllByName(name);
        return new jls.net.InetAddress(all[0]);
    }
});