jls.loader.provide('jls.net.InetSocketAddress');

jls.loader.require('jls.net.InetAddress');

/**
 * @class This class represents an Internet Protocol (IP) address and a port.
 */
jls.net.InetSocketAddress = jls.lang.Class.create( /** @lends jls.net.InetSocketAddress.prototype */
{
    initialize : function(addr, port) {
        if (addr instanceof jls.net.InetAddress) {
            this._addr = addr;
            this._port = port;
        } else if (typeof addr == 'string') {
            this._addr = jls.net.InetAddress.getByName(addr);
            this._port = port;
        } else if (typeof addr == 'number') {
            this._addr = INADDR_ANY; // TODO
            this._port = addr;
        } else {
            throw new jls.lang.Exception('Illegal argument');
        }
    },
    /**
     * Returns the InetAddress object.
     * 
     * @returns {jls.net.InetAddress} The InetAddress.
     */
    getAddress : function() {
        return this._addr;
    },
    /**
     * Returns the port number.
     * 
     * @returns {Number} The port number.
     */
    getPort : function() {
        return this._port;
    },
    /**
     * Gets the host name for this IP address.
     * 
     * @returns {String} The host name for this IP address.
     */
    getHostName : function() {
        return this._addr.getHostName();
    },
    /**
     * Gets the string representation of this socket address.
     * 
     * @returns {String} The string representation of this socket address.
     */
    toString : function() {
        return this.getHostName() + ':' + this.getPort();
    }
});
