jls.loader.provide('jls.net.PollableEvent');

jls.loader.requireLibrary('jls_net');

//jls.net.PollableEvent = _native.net.PollableEvent;

jls.net.PollableEvent = jls.lang.Class.create( /** @lends jls.net.PollableEvent.prototype */
{
    /**
     * Creates a pollable event.
     *
     * @constructs
	 * @class This class represents a special kind of file descriptor.
	 * The only I/O operation you can perform on a pollable event is to select it with the OP_READ flag.
	 * You cannot read from or write to a pollable event.
     */
    initialize : function() {
        this._event = new _native.net.PollableEvent();
    },
    /**
     * Closes this pollable event.
     * 
     * @returns {jls.net.PollableEvent} This pollable event.
     */
    close : function() {
        this._event.close();
        return this;
    },
    /**
     * Sets this pollable event.
     * 
     * @returns {jls.net.PollableEvent} This pollable event.
     */
    set : function() {
        this._event.set();
        return this;
    },
    /**
     * Blocks the calling thread until the pollable event is set.
     * 
     * @returns {jls.net.PollableEvent} This pollable event.
     */
    wait : function() {
        this._event.wait();
        return this;
    },
    getFD : function() {
        return this._event;
    }
});
