jls.loader.provide('jls.net.SelectionHandler');

/**
 * @class A selection handler is capable of multiple operations on channel (reading, writing).
 * The channel must provide the associated operations (read, write).
 * The result of a selection handle is a number indicating the handling status (>0: completed, 0: in progress, <0: failed).
 */
jls.net.SelectionHandler = jls.lang.Class.create(/** @lends jls.net.SelectionHandler.prototype */
{
    canRead : function() {
        return 'onRead' in this;
    },
    canWrite : function() {
        return 'onWrite' in this;
    },
    hasLength : function() {
        return 'length' in this;
    },
    canDo : function(op) {
        var name = 'can' + op.capitalize();
        return (name in this) && this[name]();
    },
    reset : function() {
    },
    onSelect : function(op, channel) {
        return this['on' + op.capitalize()](channel);
    },
    getOpMode : function(op) {
        return this._opMode;
    },
    setOpMode : function(op) {
        if (this._opMode == null) {
            if (this.canDo(op)) {
                this._opMode = op;
            } else if (this._opMode != op) {
                throw new jls.lang.Exception('Invalid op mode "' + op + '"');
            }
        } else if (this._opMode != op) {
            throw new jls.lang.Exception('Invalid op mode "' + op + '" != "' + this._opMode + '"');
        }
        return this;
    }
});

Object.extend(jls.net.SelectionHandler, /** @lends jls.net.SelectionHandler */
{
    STATUS_DONE : 1,
    STATUS_IN_PROGRESS : 0,
    STATUS_FAILURE : -1,
    OP_READ : 'read',
    OP_WRITE : 'write'
});

