jls.loader.provide('jls.net.SelectionHandlerSequence');

jls.loader.require('jls.net.SelectionHandler');

jls.net.SelectionHandlerSequence = jls.lang.Class.create(jls.net.SelectionHandler, /** @lends jls.net.SelectionHandlerSequence.prototype */
{
    /**
     * Creates a sequence of selection handlers.
     *
     * @constructs
	 * @augments jls.net.SelectionHandler
	 * @class A selection handler for reading and writing a sequence of selection handlers.
     */
    initialize : function() {
        this._handlers = [];
        this._current = 0;
        this._canRead = true;
        this._canWrite = true;
        for (var i = 0; i < arguments.length; i++) {
            this.addSelectionHandler(arguments[i]);
        }
    },
    addSelectionHandler : function(handler) {
        if (! (handler.canRead() || handler.canWrite())) {
            throw new jls.lang.Exception('Invalid selection handler');
        }
        if (handler.canRead() != handler.canWrite()) {
            if (handler.canRead() && this._canRead) {
                this._canWrite = false;
            } else if (handler.canWrite() && this._canWrite) {
                this._canRead = false;
            } else {
                throw new jls.lang.Exception('Invalid selection handler sequence');
            }
        }
        if (this._handlers.length == 0) {
            handler.reset();
        }
        this._handlers.push(handler);
        return this;
    },
    getSelectionHandler : function(index) {
        return this._handlers[index];
    },
    clear : function() {
        this._handlers = [];
        this._canRead = true;
        this._canWrite = true;
    },
    hasLength : function() {
        for (var i = 0; i < this._handlers.length; i++) {
            if (! this._handlers[i].hasLength()) {
                return false;
            }
        }
        return true;
    },
    length : function() {
        if (! this.hasLength()) {
            throw new jls.lang.Exception('UnsupportedOperation');
        }
        var l = 0;
        for (var i = 0; i < this._handlers.length; i++) {
            l += this._handlers[i].length();
        }
        return l;
    },
    canRead : function() {
        return this._canRead;
    },
    canWrite : function() {
        return this._canWrite;
    },
    reset : function() {
        this._current = 0;
        if (this._handlers.length > 0) {
            this._handlers[0].reset();
        }
        return this;
    },
    onSelect : function(op, channel) {
        if (this._current >= this._handlers.length) {
            // this.reset();
            return jls.net.SelectionHandler.STATUS_DONE;
        }
        for (;;) {
            var status = this._handlers[this._current].onSelect(op, channel);
            //jls.logger.info('SelectionHandlerSequence.onSelect(' + op + ')' + ', current: ' + this._current + '/' + this._handlers.length + ', status: ' + status);
            if (status <= jls.net.SelectionHandler.STATUS_IN_PROGRESS) { // In progress or failed
                return status;
            }
            // else, completed
            this._current++;
			if (this._current < this._handlers.length) {
				this._handlers[this._current].reset();
			} else {
                break;
            }
        }
        return jls.net.SelectionHandler.STATUS_DONE;
    },
    onRead : function(channel) {
        return this.onSelect(jls.net.SelectionHandler.OP_READ, channel);
    },
    onWrite : function(channel) {
        return this.onSelect(jls.net.SelectionHandler.OP_WRITE, channel);
    }
});
