jls.loader.provide('jls.net.Selector');

jls.loader.requireLibrary('jls_net');

jls.net.Selector = jls.lang.Class.create( /** @lends jls.net.Selector.prototype */
{
    /**
     * Creates a selector.
     *
     * @constructs
	 * @class This class represents a multiplexor of sockets.
	 * A selector allows to detect when I/O is ready for a set of sockets
     */
    initialize : function() {
        this._selector = new _native.net.Selector();
    },
    /**
     * Closes this selector.
     * 
     * @returns {jls.net.Selector} This selector.
     */
    close : function() {
        this._selector.close();
        return this;
    },
    /**
     * Registers a socket in this selector.
     * 
     * @param {jls.net.Socket} socket The socket to register.
     * @param {Object} key The selection key.
     * @param {Number} [mode] The interest set for this registration.
     * @returns {jls.net.Selector} This selector.
     */
    register : function(socket, key, mode) {
        mode = mode || jls.net.Selector.OP_READ;
        this._selector.register(socket.getFD(), key, mode);
        return this;
    },
    /**
     * Removes a socket from this selector.
     * 
     * @param {Object} key The selection key.
     * @returns {jls.net.Selector} This selector.
     */
    unregister : function(key) {
        this._selector.unregister(key);
        return this;
    },
    /**
     * Selects a set of keys whose corresponding channels are ready for I/O operations.
     * 
     * @returns {Array} The selector's selected-key set.
     * The array contains an Objects for each selected key with the following properties:
     * 'key': the registered key, 'inFlags': the registered interest set, 'outFlags': the selected insterest set.
     */
    select : function() {
        this._selector.select();
        return this._selector.selectedKeys();
    }
});

Object.extend(jls.net.Selector, /** @lends jls.net.Selector */
{
    OP_ACCEPT : _native.net.Selector.POLL_EXCEPT | _native.net.Selector.POLL_READ, // TODO
    OP_CONNECT : _native.net.Selector.POLL_EXCEPT | _native.net.Selector.POLL_READ, // TODO
    OP_READ : _native.net.Selector.POLL_READ,
    OP_WRITE : _native.net.Selector.POLL_WRITE
});

// TODO SelectedKey Class ?