jls.loader.provide('jls.net.SelectorThread');

jls.loader.requireLibrary('jls_net');
jls.loader.require('jls.lang.Thread');
jls.loader.require('jls.net.Selector');
jls.loader.require('jls.net.PollableEvent');

jls.net.SelectorThread = jls.lang.Class.create( /** @lends jls.net.SelectorThread.prototype */
{
    /**
     * Creates a selector thread.
     *
     * @constructs
	 * @class This class provides selector facilities hidding the selection by using a thread and a pollable event.
	 * @see jls.net.Selector
	 * @see jls.lang.Thread
	 * @see jls.net.PollableEvent
     */
    initialize : function() {
        this._selector = new jls.net.Selector();
        this._event = new jls.net.PollableEvent();
        this._selector.register(this._event, this._event, jls.net.Selector.OP_READ);
        this._thread = new jls.lang.Thread();
        this._stopped = true;
    },
    /**
     * Returns the selector.
     * 
     * @returns {jls.net.Selector} The selector.
     */
    getSelector : function() {
        return this._selector;
    },
    /**
     * Starts this selector thread.
     * 
     * @returns {jls.net.SelectorThread} This selector thread.
     */
    start : function() {
        if (this._stopped) {
            this._thread.run = this.run;
            this._stopped = false;
            this._thread.start(this);
        }
        return this;
    },
    /**
     * Stops this selector thread.
     * 
     * @returns {jls.net.SelectorThread} This selector thread.
     */
    stop : function() {
        if (! this._stopped) {
            this._stopped = true;
            this._event.set();
        }
        return this;
    },
    /**
     * Registers a socket in this selector thread.
     * 
     * @param {jls.net.Socket} socket The socket to register.
     * @param {Function} handle The handle for this registration.
     * @param {Number} [mode] The interest set for this registration.
     * @returns {Object} The selection key.
     */
    register : function(socket, handle, mode) {
        var key = this.lazyregister(socket, handle, mode);
        if (! this._stopped) {
            this._event.set();
        }
        return key;
    },
    lazyregister : function(socket, handle, mode) {
        var key = {
            selectorThread: this,
            handle: handle,
            socket: socket
        };
        mode = mode || _native.net.POLL_READ;
        this._selector.register(socket, key, mode);
        return key;
    },
    /**
     * Removes a socket from this selector thread.
     * 
     * @param {Object} key The selection key.
     * @returns {jls.net.SelectorThread} This selector thread.
     */
    unregister : function(key) {
        this.lazyunregister(key);
        if (! this._stopped) {
            this._event.set();
        }
        return this;
    },
    lazyunregister : function(key) {
        this._selector.unregister(key);
        return this;
    },
    changeMode : function(key, mode) {
        return this._selector.register(key.socket, key, mode);
    },
    changeHandler : function(key, handle) {
        var oldHandle = key.handle;
        key.handle = handle;
        return oldHandle;
    },
    run : function() {
        jls.logger.debug('SelectorThread started');
        while (! this._stopped) {
            var keys = this._selector.select();
            jls.logger.debug(keys.length + ' key(s) selected');
            //jls.lang.Thread.sleep(1000);
            for (var i = 0; i < keys.length;  i++) {
                var sk = keys[i];
                if ('handle' in sk.key) {
                    jls.logger.debug('handle...');
                    sk.key.handle(sk.key, sk.inFlags, sk.outFlags);
                } else if (sk.key instanceof jls.net.PollableEvent) {
                    jls.logger.debug('pollable event received');
                    sk.key.wait();
                } else {
                    jls.logger.debug('unknown event received');
                }
            }
        }
        
    }
});
