jls.loader.provide('jls.net.ServerSocket');

jls.loader.requireLibrary('jls_net');
jls.loader.require('jls.net.Socket');
jls.loader.require('jls.net.InetAddress');

jls.net.ServerSocket = jls.lang.Class.create( /** @lends jls.net.ServerSocket.prototype */
{
    /**
     * Creates a TCP server socket.
     *
     * @param {Number} [port] The port number to bind to.
     * @param {Number} [backlog] The maximum length of the queue.
     * @param {jls.net.InetAddress} [bindAddr] The host the server will bind to.
     * @constructs
	 * @class This class represents a server TCP socket.
     */
    initialize : function(port, backlog, bindAddr) {
        this._fd = new _native.net.Socket();
        if (port) {
            this.bind(port, backlog, bindAddr);
        }
    },
    /**
     * Binds the ServerSocket to a specific address (IP address and port number).
     *
     * @param {Number} port The port number to bind to.
     * @param {Number} [backlog] The maximum length of the queue.
     * @param {jls.net.InetAddress} [bindAddr] The host the server will bind to.
     */
    bind : function(port, backlog, bindAddr) {
        this._backlog = backlog || 32;
        if (bindAddr && (bindAddr instanceof jls.net.InetAddress)) {
            this._fd.bind(port, bindAddr.getHostAddress());
        } else {
            this._fd.bind(port);
        }
        this._fd.listen(this._backlog);
    },
    /**
     * Closes this server socket.
     * 
     * @returns {jls.net.ServerSocket} This server socket.
     */
    close : function() {
        this._fd.close();
        return this;
    },
    /**
     * Listens for a connection to be made to this socket and accepts it.
     * 
     * @returns {jls.net.Socket} The new socket.
     */
    accept : function() {
        return new jls.net.Socket(this._fd.accept());
    },
    /**
     * Adjusts this server socket's blocking mode.
     * 
     * @param {Boolean} block Whether the socket is placed in blocking mode.
     * @returns {jls.net.ServerSocket} This server socket.
     */
    configureBlocking : function(block) {
        this._fd.configureBlocking(block);
        return this;
    },
    getChannel : function() {
        return this;
    },
    getFD : function() {
        return this._fd;
    }
});

