jls.loader.provide('jls.net.http.HttpContext');

/**
 * @class This class represents the context of an HTTP root URI path in a HttpServer.
 * It defines the HTTP exchange handler(function) that is called once the request header has been proceed.
 */
jls.net.http.HttpContext = jls.lang.Class.create(/** @lends jls.net.http.HttpContext.prototype */
{
    initialize : function(path) {
        this._path = path;
        this._attributes = {};
    },
    hasAttribute : function(key) {
        return key in this._attributes;
    },
    /**
     * Sets an attribute for this context.
     * 
     * @param {String} key The key of the attribute.
     * @param {String} value The value of the attribute.
     * @returns {String} the previous value or null is there is no previous value.
     */
    setAttribute : function(key, value) {
        var old = null;
        if (key in this._attributes) {
            old = this._attributes[key];
        }
        this._attributes[key] = value;
        return old;
    },
    /**
     * Gets an attribute for this context.
     * 
     * @param {String} key The key of the attribute.
     * @returns {String} the value of the attribute.
     */
    getAttribute : function(key) {
        if (key in this._attributes) {
            return this._attributes[key];
        }
        return null;
    },
    setAttributes : function(values) {
        for (var key in values) {
          this.setAttribute(key, values[key]);
        }
        return this;
    },
    getAttributes : function() {
        return this._attributes;
    },
    getFilters : function() {
        return [];
    },
    getPath : function() {
        return this._path;
    },
    getHandler : function() {
        return this._handler;
    },
    setHandler : function(handler) {
        this._handler = handler;
    }
});

