jls.loader.provide('jls.net.http.HttpExchange');

jls.loader.require('jls.net.http.HttpResponseHeader');
jls.loader.require('jls.net.SelectionHandlerSequence');

/**
 * @class This class encapsulates a HTTP request received and a response to be generated in one exchange.
 * It provides methods for examining the request from the client, and for building and sending the response.
 */
jls.net.http.HttpExchange = jls.lang.Class.create(/** @lends jls.net.http.HttpExchange.prototype */
{
    initialize : function(context, header) {
        this._context = context;
        this._header = header; // jls.net.http.HttpRequestHeader
		var version = header.getVersion();
		//version = jls.net.http.HttpHeader.VERSION_PREFIX + jls.net.http.HttpHeader.VERSION_1_0;
        this._responseHeader = new jls.net.http.HttpResponseHeader(version);
        this._requestHandler = null;
    },
    /**
     * Gets the request URI.
     * 
     * @returns {String} the request URI.
     */
    getRequestURI : function() {
        return this._header.getUri();
    },
    /**
     * Gets the request method.
     * 
     * @returns {String} the request method.
     */
    getRequestMethod : function() {
        return this._header.getMethod();
    },
    /**
     * Gets the context.
     * 
     * @returns {jls.net.http.HttpContext} the context.
     */
    getHttpContext : function() {
        return this._context;
    },
    close : function() {
    },
    getRemoteAddress : function() {},
    /**
     * Gets the response code.
     * 
     * @returns {Number} the response code.
     */
    getResponseCode : function() {
        this._responseHeader.getStatusCode();
    },
    getLocalAddress : function() {},
    getProtocol : function() {
        return this._header.getVersion();
    },
    /**
     * Gets the request header.
     * 
     * @returns {jls.net.http.HttpRequestHeader} the request header.
     */
    getRequestHeaders : function() {
        return this._header;
    },
    /**
     * Gets the response header.
     * 
     * @returns {jls.net.http.HttpResponseHeader} the response header.
     */
    getResponseHeaders : function() {
        return this._responseHeader;
    },
    /*
     * If responseLength > 0, specifies a fixed response body length that exact number of bytes must be written
	 * to the stream acquired from getResponseBody(), or else if equal to 0, then chunked encoding is used, 
	 * and an arbitrary number of bytes may be written.
	 * if <= -1, then no response body length is specified and no response body may be written.
     */
    sendResponseHeaders : function(rCode, responseLength) {
        this._responseHeader.setStatusCode(rCode);
		if (typeof responseLength == 'undefined') {
			throw new jls.lang.Exception('Invalid response length');
		} else if (typeof responseLength == 'string') {
			var sh = new jls.net.BufferSelectionHandler(jls.lang.ByteBuffer.fromString(responseLength, 'UTF-8'));
			//jls.logger.debug('response body: ->' + responseLength + '<-');
			this.setResponseBodySelectionHandler(sh);
			responseLength = sh.hasLength() ? sh.length() : 0;
            if (! this._responseHeader.hasField(jls.net.http.HttpHeader.HEADER_CONTENT_TYPE)) {
                this._responseHeader.setField(jls.net.http.HttpHeader.HEADER_CONTENT_TYPE, 'text/html; charset=UTF-8');
            }
		} else if (responseLength instanceof jls.net.SelectionHandler) {
			this.setResponseBodySelectionHandler(responseLength);
			responseLength = responseLength.hasLength() ? responseLength.length() : 0;
		}
        this._responseHeader.setField(jls.net.http.HttpHeader.HEADER_CONTENT_LENGTH, responseLength);
		//jls.logger.debug('response header: ->' + this._responseHeader.toString() + '<-');
    },
    /**
     * Sets the request body selection handler.
     * 
     * @param {jls.net.SelectionHandler} sh The selection handler to use for the request body.
     */
    setRequestBodySelectionHandler : function(sh) {
        this._requestHandler = sh;
    },
    /**
     * Sets the response body selection handler.
     * 
     * @param {jls.net.SelectionHandler} sh The selection handler to use for the response body.
     */
    setResponseBodySelectionHandler : function(sh) {
        this._responseHandler = new jls.net.SelectionHandlerSequence(this._responseHeader, sh);
        //this._responseHandler.addSelectionHandler(sh);
    },
    onRead : function(channel) {
        if (this._requestHandler == null) {
            // No request body to read ...
            return jls.net.SelectionHandler.STATUS_DONE;
        }
        return this._requestHandler.onRead(channel);
    },
    onWrite : function(channel) {
        return this._responseHandler.onWrite(channel);
    }
});

/*Object.extend(jls.net.http.HttpExchange,
{
});*/

