jls.loader.provide('jls.net.http.HttpMultiPartBody');

jls.loader.require('jls.net.SelectionHandlerSequence');
jls.loader.require('jls.net.BufferSelectionHandler');
jls.loader.require('jls.lang.ByteBuffer');

jls.net.http.HttpMultiPartBody = jls.lang.Class.create(jls.net.SelectionHandlerSequence, /** @lends jls.net.http.HttpMultiPartBody.prototype */
{
    /**
     * Creates a multipart HTTP content.
     *
     * @param {String} boundary The boundary.
     * @constructs
	 * @augments jls.net.SelectionHandlerSequence
	 * @class This class is a selection handler for multipart HTTP content.
     */
    initialize : function($super, boundary) {
        if (typeof boundary != 'string') {
            throw new jls.lang.Exception('Invalid boundary');
        }
        $super();
        this._boundary = boundary;
        this._boundaryContent = null;
    },
    /**
     * Adds a content.
     * 
     * @param {jls.net.SelectionHandler} content The content to add.
     */
    addContent : function(content) {
        if (this._contents.length > 0) {
            // prepare boundary
            if (this._boundaryContent == null) {
                var buffer = jls.lang.ByteBuffer.allocate(this._boundary.length);
                buffer.putString(this._boundary);
                buffer.flip();
                this._boundaryContent = new jls.net.BufferSelectionHandler(buffer);
            }
            this.addSelectionHandler(this._boundaryContent);
        }
        this.addSelectionHandler(content);
        return this;
    },
    /**
     * Gets a content.
     * 
     * @param {Number} content The content index.
     * @returns {jls.net.SelectionHandler} The content.
     */
    getContent : function($super, index) {
        return this.getSelectionHandler(index * 2);
    },
    onRead : function(output) {
        throw new jls.lang.Exception('Not available');
    }
});
