jls.loader.provide('jls.net.http.HttpRequestHeader');

jls.loader.require('jls.net.http.HttpHeader');

/*
Request      = Request-Line
                           *( general-header
                            | request-header
                            | entity-header )
                           CRLF
                           [ message-body ]
Request-Line = Method SP Request-URI SP HTTP-Version CRLF
*/
jls.net.http.HttpRequestHeader = jls.lang.Class.create(jls.net.http.HttpHeader, /** @lends jls.net.http.HttpRequestHeader.prototype */
{
    /**
     * Creates an HTTP request header.
     *
     * @param {String} [method] The method.
     * @param {String} [uri] The uri.
     * @param {String} [version] The version.
     * @param {Object} [fields] The fields.
     * @constructs
	 * @augments jls.net.http.HttpHeader
	 * @class This class represents an HTTP request header.
     */
    initialize : function($super, method, uri, version, fields) {
        this._method = jls.net.http.HttpHeader.METHOD_GET;
        this._uri = '/';
        this._version = jls.net.http.HttpHeader.VERSION_PREFIX + jls.net.http.HttpHeader.VERSION_1_0;
        if (method) {
            this.setMethod(method);
        }
        if (uri) {
            this.setUri(uri);
        }
        if (version) {
            this.setVersion(version);
        }
        $super(null, fields);
    },
    /**
     * Returns the method.
     * 
     * @returns {String} The version.
     */
    getMethod : function() {
        return this._method;
    },
    /**
     * Sets the method.
     * 
     * @param {String} version The version.
     */
    setMethod : function(method) {
        this._method = method;
        return this;
    },
    /**
     * Returns the URI.
     * 
     * @returns {String} The URI.
     */
    getUri : function() {
        return this._uri;
    },
    /**
     * Sets the URI.
     * 
     * @param {String} version The URI.
     */
    setUri : function(uri) {
        jls.logger.trace('setUri("' + uri + '")');
        this._uri = uri;
        return this;
    },
    /**
     * Returns the version.
     * 
     * @returns {String} The version.
     */
    getVersion : function() {
        return this._version;
    },
    /**
     * Sets the version.
     * 
     * @param {String} version The version.
     */
    setVersion : function(version) {
        this._version = version;
        return this;
    },
    getStartLine : function() {
        return this.getMethod() + ' ' + this.getUri() + ' ' + this.getVersion();
    },
    setStartLine : function(line) {
        jls.logger.trace('setStartLine("' + line + '")');
        var items = line.split(' ');
        if (items.length != 3) {
            throw new jls.lang.IllegalArgumentException();
        }
        this.setMethod(items[0]);
        this.setUri(items[1]);
        this.setVersion(items[2]);
        return this;
    }
});
