jls.loader.provide('jls.net.http.HttpResponseHeader');

jls.loader.require('jls.net.http.HttpHeader');

/*
Response    = Status-Line
                       *( general-header
                        | response-header
                        | entity-header )
                       CRLF
                       [ message-body ]
Status-Line = HTTP-Version SP Status-Code SP Reason-Phrase CRLF

HTTP/1.0 404 Not Found
Content-Type: text/html; charset=UTF-8
X-Content-Type-Options: nosniff
Date: Sun, 19 Sep 2010 19:49:09 GMT
Server: sffe
Content-Length: 1360
X-XSS-Protection: 1; mode=block
*/
jls.net.http.HttpResponseHeader = jls.lang.Class.create(jls.net.http.HttpHeader, /** @lends jls.net.http.HttpResponseHeader.prototype */
{
    /**
     * Creates an HTTP response header.
     *
     * @param {String} [version] The version.
     * @param {Number} [statusCode] The status code.
     * @param {String} [reasonPhrase] The reason phrase.
     * @param {Object} [fields] The fields.
     * @constructs
	 * @augments jls.net.http.HttpHeader
	 * @class This class represents an HTTP response header.
     */
    initialize : function($super, version, statusCode, reasonPhrase, fields) {
        this._version = jls.net.http.HttpHeader.VERSION_PREFIX + jls.net.http.HttpHeader.VERSION_1_0;
        this._statusCode = jls.net.http.HttpHeader.HTTP_OK;
        this._reasonPhrase = 'n/a';
        if (statusCode) {
            this.setStatusCode(statusCode);
        }
        if (reasonPhrase) {
            this.setReasonPhrase(reasonPhrase);
        }
        if (version) {
            this.setVersion(version);
        }
        $super(null, fields);
    },
    /**
     * Returns the version.
     * 
     * @returns {String} The version.
     */
    getVersion : function() {
        return this._version;
    },
    /**
     * Sets the version.
     * 
     * @param {String} version The version.
     */
    setVersion : function(version) {
        this._version = version;
        return this;
    },
    /**
     * Returns the status code.
     * 
     * @returns {String} The status code.
     */
    getStatusCode : function() {
        return this._statusCode;
    },
    /**
     * Sets the status code.
     * 
     * @param {String} version The status code.
     */
    setStatusCode : function(statusCode) {
        this._statusCode = statusCode;
        return this;
    },
    /**
     * Returns the reason phrase.
     * 
     * @returns {String} The reason phrase.
     */
    getReasonPhrase : function() {
        return this._reasonPhrase;
    },
    /**
     * Sets the reason phrase.
     * 
     * @param {String} version The reason phrase.
     */
    setReasonPhrase : function(reasonPhrase) {
        this._reasonPhrase = reasonPhrase;
        return this;
    },
    getStartLine : function() {
        return this.getVersion() + ' ' + this.getStatusCode() + ' ' + this.getReasonPhrase();
    },
    setStartLine : function(line) {
        var items = line.split(' ');
        if (items.length < 3) {
            throw new jls.lang.IllegalArgumentException();
        }
        this.setVersion(items[0]);
        this.setStatusCode(items[1]);
        this.setReasonPhrase(items[2]); // TODO the reason phrase can contain spaces
        return this;
    }
});
