jls.loader.provide('jls.net.http.HttpURLConnection');

jls.loader.require('jls.net.Socket');
jls.loader.require('jls.net.InetSocketAddress');
jls.loader.require('jls.net.http.HttpHeader');
jls.loader.require('jls.net.http.HttpRequestHeader');
jls.loader.require('jls.net.http.HttpResponseHeader');
jls.loader.require('jls.net.SelectionHandler');
jls.loader.require('jls.net.SelectionHandlerSequence');

/**
 * @class This class represents an URL connection over HTTP.
 */
jls.net.http.HttpURLConnection = jls.lang.Class.create( /** @lends jls.net.http.HttpURLConnection.prototype */
{
    initialize : function(url) {
        this._requestHeader = new jls.net.http.HttpRequestHeader();
        this._requestBody = null;
        this._responseHeader = new jls.net.http.HttpResponseHeader();
        this._responseBody = null;
        this.setUrl(url);
    },
    setUrl : function(url) {
		var port = url.getPort();
		if (port == -1) {
			port = url.getDefaultPort();
		}
		this._socket = new jls.net.Socket();
        this._address = new jls.net.InetSocketAddress(url.getHost(), port);
        this._requestHeader.clear();
        this._responseHeader.clear();
        this._requestHeader.setUri(url.getFile());
        this._requestHeader.setField(jls.net.http.HttpHeader.HEADER_HOST, url.getHost());
    },
    /**
     * Connects.
     *
     */
    connect : function() {
		this._socket.connect(this._address);
    },
    /**
     * Sends.
     *
     */
    send : function() {
        var sequenceHandler = new jls.net.SelectionHandlerSequence(this._requestHeader);
        if (this._requestBody != null) {
        	var length = this._requestBody.length();
            jls.logger.info('send() body ' + length);
            this._requestHeader.setContentLength(length);
            sequenceHandler.addSelectionHandler(this._requestBody);
        }
        jls.logger.info('send() request header ->' + this._requestHeader.toString() + '<-');
        if (sequenceHandler.onWrite(this._socket) != jls.net.SelectionHandler.STATUS_DONE) {
            throw new jls.lang.Exception('Cannot send request');
        }
        if (this._responseHeader.onRead(this._socket) != jls.net.SelectionHandler.STATUS_DONE) {
            throw new jls.lang.Exception('Cannot receive response header');
        }
        jls.logger.info('response header ->' + this._responseHeader.toString() + '<-');
        this.onResponseHeader();
        if (this._responseBody == null) {
            // TODO Create a nop selection handler with content length
            return;
        }
        if (this._responseBody.onRead(this._socket) != jls.net.SelectionHandler.STATUS_DONE) {
            throw new jls.lang.Exception('Cannot receive response body');
        }
        this.onResponseBody();
    },
    /**
     * This function is called when the response header is available, can be overrided.
     *
     */
    onResponseHeader : function() {
    },
    /**
     * This function is called when the response body is available, can be overrided.
     *
     */
    onResponseBody : function() {
    },
    /**
     * Connects this socket to the server.
     * 
     * @returns {Number} The response header.
     */
    getContentLength : function() {
        return this._responseHeader.getContentLength();
    },
    /**
     * Returns the response header.
     * 
     * @returns {jls.net.http.HttpResponseHeader} The response header.
     */
    getResponseHeader : function() {
        return this._responseHeader;
    },
    /**
     * Returns the response body selection handler.
     * 
     * @returns {jls.net.SelectionHandler} The response body selection handler.
     */
    getResponseBodySelectionHandler : function() {
        return this._responseBody;
    },
    /**
     * Sets the response body selection handler.
     *
     * @param {jls.net.SelectionHandler} sh The response body selection handler.
     */
    setResponseBodySelectionHandler : function(sh) {
        this._responseBody = sh;
    },
    /**
     * Sets the request body selection handler.
     *
     * @param {jls.net.SelectionHandler} sh The request body selection handler.
     */
    setRequestBodySelectionHandler : function(sh) {
        this._requestBody = sh;
    },
    /**
     * Sets the requests method.
     *
     * @param {String} value The requests method.
     */
    setRequestMethod : function(value) {
		this._requestHeader.setMethod(value);
    },
    /**
     * Sets a requests property.
     *
     * @param {String} key The property key.
     * @param {String} value The property value.
     */
    setRequestProperty : function(key, value) {
		this._requestHeader.setField(key, value);
    },
    /**
     * Disconnects.
     *
     */
    disconnect : function() {
		this._socket.close();
    }
});

/*Object.extend(jls.net.http.HttpURLConnection,
{
    HTTP_PORT : 80,
    HTTPS_PORT : 443
});
*/