jls.loader.provide('jls.net.http.ServerMgr');

jls.loader.require('jls.net.InetSocketAddress');
jls.loader.require('jls.net.URL');
jls.loader.require('jls.net.http.HttpServer');

/**
 * @namespace Provides HTTP classes.
 * @see jls.net.http.ServerMgr
 * @name jls.net.http
 */

/**
 * @class A manager for the HTTP servers.
 */
jls.net.http.ServerMgr = jls.lang.Class.create(/** @lends jls.net.http.ServerMgr.prototype */
{
    initialize : function() {
		this._servers = {}; // HttpServers
    },
    /**
     * Creates a context at the given address.
     * 
     * @param {String} address The address of the context.
     * @returns {jls.net.http.HttpContext} the created context.
     */
    createContext : function(address) {
        jls.logger.debug('ServerMgr.createContext("' + address + '")');
		var url = new jls.net.URL(address);
		var port = url.getPort();
		if (port == -1) {
			port = url.getDefaultPort();
		}
		var addr = new jls.net.InetSocketAddress(url.getHost(), port);
		var addressId = addr.toString();
		var server;
		if (addressId in this._servers) {
			server = this._servers[addressId];
		} else {
			server = jls.net.http.HttpServer.create(addr, 5);
			server.start();
            this._servers[addressId] = server;
		}
		return server.createContext(url.getPath());
    },
    shutdown : function() {
		for (var id in this._servers) {
			this._servers[id].stop();
		}
    }
});

Object.extend(jls.net.http.ServerMgr, /** @lends jls.net.http.ServerMgr */
{
	_instance : new jls.net.http.ServerMgr(),
    /**
     * Get the instance of the manager.
     * 
     * @returns {jls.net.http.ServerMgr} the instance.
     */
    getInstance : function() {
		return jls.net.http.ServerMgr._instance;
    }
});

