jls.loader.provide('jls.util.Exif');

jls.loader.requireLibrary('jls_exif');

/**
 * @class This class provides various EXIF functions.
 */
jls.util.Exif = jls.lang.Class.create({});

Object.extend(jls.util.Exif, /** @lends jls.util.Exif */
{
    /**
     * Extracts EXIF.
     * 
     * @param {String} filename The image to process.
     * @returns {Object} The EXIF info.
     */
    extract : function(filename) {
        return _native.exif.read(filename);
    },
    /**
     * Parses an EXIF date field as a local date.
     * EXIF dates are formatted like "2011:03:10 16:41:24".
     * 
     * @param {String} str The date as a string .
     * @returns {Date} The date.
     */
    parseDate : function(str) {
    	//2011:03:10 16:41:24
    	var fields = str.match(/^(\d+):(\d+):(\d+) (\d+):(\d+):(\d+)$/);
    	return new Date(parseInt(fields[1], 10), parseInt(fields[2], 10) - 1, parseInt(fields[3], 10),
    			parseInt(fields[4], 10), parseInt(fields[5], 10), parseInt(fields[6], 10));
    }
});

