jls.loader.provide('jls.util.zip.Inflater');

jls.util.zip.Inflater = jls.lang.Class.create( /** @lends jls.util.zip.Inflater.prototype */
{
    /**
     * Creates an inflater.
     *
     * @param {String} name The entry name.
     * @constructs
	 * @class This class provides support for the ZLIB inflater.
     */
    initialize : function(wBits) {
        this._no = new _native.core.ZStream();
        this._wBits = (typeof wBits == 'undefined') ? -jls.util.zip.Inflater.MAX_WBITS : wBits;
        this._no.inflateInit(this._wBits);
        this._lastResult = _native.core.ZStream.Z_OK;
    },
    setDictionary : function(buffer) {
    	// TODO
    },
    /**
     * Sets the input.
     *
     * @param {jls.lang.ByteBuffer} buffer The buffer to inflate.
     */
    setInput : function(buffer) {
    	this._inBuf = buffer;
    },
    /**
     * Inflates the input into the specified buffer.
     *
     * @param {jls.lang.ByteBuffer} buffer The buffer to fill.
     * @returns {Number} The inflated byte count.
     */
    inflate : function(buffer) {
    	this._no.nextIn(this._inBuf.byteArray(), this._inBuf.offset(), this._inBuf.remaining());
    	this._no.nextOut(buffer.byteArray(), buffer.offset(), buffer.remaining());
    	this._lastResult = this._no.inflate();
        var count = buffer.remaining() - this._no.availOut();
        if (count > 0) {
            buffer.incrementPosition(count);
        }
        count = this._inBuf.remaining() - this._no.availIn();
        if (count > 0) {
        	this._inBuf.incrementPosition(count);
        }
        return count;
    },
    /**
     * Tells if the inflater needs a dictionary.
     *
     * @returns {Boolean} true if the inflater needs a dictionary.
     */
    needsDictionary : function() {
        return this._lastResult == _native.core.ZStream.Z_NEED_DICT;
    },
    /**
     * Tells if the inflater needs more input data.
     *
     * @returns {Boolean} true if the inflater needs more input data.
     */
    needsInput : function() {
        return this._inBuf.remaining() == 0;
    },
    getTotalIn : function() {
        return 0; // TODO
    },
    getTotalOut : function() {
        return 0; // TODO
    },
    reset : function() {
        this._no.inflateInit(this._wBits);
    },
    /**
     * Ends the inflater.
     *
     */
    end : function() {
    	this._no.inflateEnd();
    },
    /**
     * Tells if the inflater has finished to consume the input data.
     *
     * @returns {Boolean} true if the inflater has finished to consume the input data.
     */
    finished : function() {
        return this._lastResult == _native.core.ZStream.Z_NEED_DICT;
    }
});

Object.extend(jls.util.zip.Inflater, /** @lends jls.util.zip.Inflater */
{
    MAX_WBITS : 15,
});
