jls.loader.provide('jls.util.zip.ZipInputStream');

jls.loader.require('jls.util.zip.ZipEntry');
jls.loader.require('jls.io.File');
jls.loader.require('jls.io.FileChannel');
jls.loader.require('jls.io.FileInputStream');
jls.loader.require('jls.lang.Struct');

jls.util.zip.ZipInputStream = jls.lang.Class.create(
{
    initialize : function(input) {
        this._buffer = jls.lang.ByteBuffer.allocate(1024);
        this._buffer.setByteOrder(jls.lang.Buffer.LITTLE_ENDIAN);

        this._endOfCentralDirectoryRecord = new jls.lang.Struct(jls.util.zip.ZipEntry.getEndOfCentralDirectoryRecordStructDefinition(), this._buffer); // 22
        this._dataDescriptor = new jls.lang.Struct(jls.util.zip.ZipEntry.getDataDescriptorStructDefinition(), this._buffer); // 12
        this._localFileHeader = new jls.lang.Struct(jls.util.zip.ZipEntry.getLocalFileHeaderStructDefinition(), this._buffer); // 30
        this._fileHeader = new jls.lang.Struct(jls.util.zip.ZipEntry.getFileHeaderStructDefinition(), this._buffer); // 46
    },
    toString : function() {
        return '';
    }
});

Object.extend(jls.util.zip.ZipInputStream,
{
    // TODO Remove, for testing purpose
    main : function(args) {
        var filename = args[0];
        var file = new jls.io.File(filename);
        if (! file.exists()) {
            jls.lang.System.out.println('File not found: ' + filename);
            jls.lang.System.exit(1);
        }
        jls.lang.System.out.println('Openning file: ' + filename);
        var zipIn = new jls.util.zip.ZipInputStream(new jls.io.FileInputStream(file));
    }
});
