jls.loader.provide('jls.win32.Button');

jls.loader.require('jls.win32.Window');

jls.win32.Button = jls.lang.Class.create(jls.win32.Window,
{
    initialize : function($super, name, style, x, y, w, h, parent, id, exStyle, param) {
        $super(jls.win32.Button.CLASSNAME, name, style, x, y, w, h, parent, id, exStyle, param);
    },
    getSelected : function() {
        var sel = this.sendMessage(jls.win32.Button.BM_GETCHECK, 0, 0);
        return sel == jls.win32.Button.BST_CHECKED;
    },
    setSelected : function(value) {
        if (this._window != null) {
            this.sendMessage(jls.win32.Button.BM_GETCHECK, value ? jls.win32.Button.BST_CHECKED : jls.win32.Button.BST_UNCHECKED, 0);
        }
        return this;
    }
});

Object.extend(jls.win32.Button,
{
    BS_3STATE                : 0x00000005,
    BS_AUTO3STATE            : 0x00000006,
    BS_AUTOCHECKBOX          : 0x00000003,
    BS_AUTORADIOBUTTON       : 0x00000009,
    BS_BITMAP                : 0x00000080,
    BS_BOTTOM                : 0x00000800,
    BS_CENTER                : 0x00000300,
    BS_CHECKBOX              : 0x00000002,
    BS_DEFPUSHBUTTON         : 0x00000001,
    BS_GROUPBOX              : 0x00000007,
    BS_ICON                  : 0x00000040,
    BS_LEFT                  : 0x00000100,
    BS_LEFTTEXT              : 0x00000020,
    BS_MULTILINE             : 0x00002000,
    BS_NOTIFY                : 0x00004000,
    BS_OWNERDRAW             : 0x0000000b,
    BS_PUSHBUTTON            : 0x00000000,
    BS_PUSHLIKE              : 0x00001000,
    BS_RADIOBUTTON           : 0x00000004,
    BS_RIGHT                 : 0x00000200,
    BS_RIGHTBUTTON           : 0x00000020,
    BS_TEXT                  : 0x00000000,
    BS_TOP                   : 0x00000400,
    BS_USERBUTTON            : 0x00000008,
    BS_VCENTER               : 0x00000c00,
    BS_FLAT                  : 0x00008000,
    BS_3STATE                : 0x00000005,

    BM_GETCHECK              : 0x000000F0,
    BM_SETCHECK              : 0x000000F1,
    BM_GETSTATE              : 0x000000F2,
    BM_SETSTATE              : 0x000000F3,
    BM_CLICK                 : 0x000000F5,
    BM_SETIMAGE              : 0x000000F7,
    
    BST_UNCHECKED            : 0,
    BST_CHECKED              : 1,
    BST_INDETERMINATE        : 2,
    BST_PUSHED               : 4,
    BST_FOCUS                : 8,

    CLASSNAME: 'Button'
});
