jls.loader.provide('jls.win32.ButtonElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.Button');

jls.win32.ButtonElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._text = '';
        $super(parameters, parent);
    },
    onCreate : function() {
    	//this.createWindow(jls.win32.Button, jls.win32.Button.CLASSNAME, this.getText());
        this._window = new jls.win32.Button(this.getText(), this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this.getH(),
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
    },
    /*getWindowStyle : function($super) {
        return jls.win32.Window.WS_CHILD | jls.win32.Window.WS_VISIBLE;// | jls.win32.Button.BS_BITMAP | jls.win32.Button.BS_ICON;
    },*/
    getSelected : function() {
        return this._window.getSelected();
    },
    setSelected : function(value) {
        if (this._window != null) {
            this._window.setSelected(value);
        }
        this._text = value;
        return this;
    },
    setIcon : function(name) {
        var icon = jls.win32.WindowElement.getIcon(name);
        if (icon) {
            this._window.sendMessage(jls.win32.Button.BM_SETIMAGE, jls.win32.Image.IMAGE_ICON, icon);
        }
        return this;
    },
    getText : function() {
        return this._text;
    },
    setText : function(value) {
        if (this._window != null) {
            this._window.setText(value);
        }
        this._text = value;
        return this;
    }
});

