jls.loader.provide('jls.win32.ComboBox');

jls.loader.require('jls.win32.Window');

jls.win32.ComboBox = jls.lang.Class.create(jls.win32.Window,
{
    initialize : function($super, title, style, x, y, w, h, parent, id, exStyle, param) {
        $super(jls.win32.ComboBox.CLASSNAME, title, style, x, y, w, h, parent, id, exStyle, param);
    },
    addString : function(s) {
        this.sendMessage(jls.win32.ComboBox.CB_ADDSTRING, 0, s);
    },
    getCurrentSelectionIndex : function() {
        return this.sendMessage(jls.win32.ComboBox.CB_GETCURSEL, 0, 0);
    },
    getListBoxText : function(index) {
        var length = this.sendMessage(jls.win32.ComboBox.CB_GETLBTEXTLEN, index, 0);
        if (length <= 0) {
            return '';
        }
        var buffer = jls.lang.ByteBuffer.allocate(length + 1);
        var len = this.sendMessage(jls.win32.ComboBox.CB_GETLBTEXT, index, buffer.byteArray());
        if (len <= 0) {
            return '';
        }
        buffer.clear();
        buffer.setLimit(len);
        return buffer.getString(); // TODO Fix charset
    },
    getCurrentSelectionText : function() {
    	var index = this.getCurrentSelectionIndex();
    	//jls.logger.warn('ComboBox index: ' + index);
    	if (index < 0) {
            return this.getText();
    	}
        return this.getListBoxText(index);
    }
});

Object.extend(jls.win32.ComboBox,
{
    CBS_AUTOHSCROLL          : 0x00000040,
    CBS_DISABLENOSCROLL      : 0x00000800,
    CBS_DROPDOWN             : 0x00000002,
    CBS_DROPDOWNLIST         : 0x00000003,
    CBS_HASSTRINGS           : 0x00000200,
    CBS_LOWERCASE            : 0x00004000,
    CBS_NOINTEGRALHEIGHT     : 0x00000400,
    CBS_OEMCONVERT           : 0x00000080,
    CBS_OWNERDRAWFIXED       : 0x00000010,
    CBS_OWNERDRAWVARIABLE    : 0x00000020,
    CBS_SIMPLE               : 0x00000001,
    CBS_SORT                 : 0x00000100,
    CBS_UPPERCASE            : 0x00002000,

    CB_ADDSTRING             : 0x00000143,
    CB_DELETESTRING          : 0x00000144,
    CB_DIR                   : 0x00000145,
    CB_FINDSTRING            : 0x0000014c,
    CB_FINDSTRINGEXACT       : 0x00000158,
    CB_GETCOUNT              : 0x00000146,
    CB_GETCURSEL             : 0x00000147,
    CB_GETDROPPEDCONTROLRECT : 0x00000152,
    CB_GETDROPPEDSTATE       : 0x00000157,
    CB_GETDROPPEDWIDTH       : 0x0000015f,
    CB_GETEDITSEL            : 0x00000140,
    CB_GETEXTENDEDUI         : 0x00000156,
    CB_GETHORIZONTALEXTENT   : 0x0000015d,
    CB_GETITEMDATA           : 0x00000150,
    CB_GETITEMHEIGHT         : 0x00000154,
    CB_GETLBTEXT             : 0x00000148,
    CB_GETLBTEXTLEN          : 0x00000149,
    CB_GETLOCALE             : 0x0000015a,
    CB_GETTOPINDEX           : 0x0000015b,
    CB_INITSTORAGE           : 0x00000161,
    CB_INSERTSTRING          : 0x0000014a,
    CB_LIMITTEXT             : 0x00000141,
    CB_RESETCONTENT          : 0x0000014b,
    CB_SELECTSTRING          : 0x0000014d,
    CB_SETCURSEL             : 0x0000014e,
    CB_SETDROPPEDWIDTH       : 0x00000160,
    CB_SETEDITSEL            : 0x00000142,
    CB_SETEXTENDEDUI         : 0x00000155,
    CB_SETHORIZONTALEXTENT   : 0x0000015e,
    CB_SETITEMDATA           : 0x00000151,
    CB_SETITEMHEIGHT         : 0x00000153,
    CB_SETLOCALE             : 0x00000159,
    CB_SETTOPINDEX           : 0x0000015c,
    CB_SHOWDROPDOWN          : 0x0000014f,

    CBN_CLOSEUP              : 0x00000008,
    CBN_DBLCLK               : 0x00000002,
    CBN_DROPDOWN             : 0x00000007,
    CBN_EDITCHANGE           : 0x00000005,
    CBN_EDITUPDATE           : 0x00000006,
    CBN_ERRSPACE             : 0xffffffff,
    CBN_KILLFOCUS            : 0x00000004,
    CBN_SELCHANGE            : 0x00000001,
    CBN_SELENDCANCEL         : 0x0000000a,
    CBN_SELENDOK             : 0x00000009,
    CBN_SETFOCUS             : 0x00000003,
    
    CLASSNAME: 'ComboBox'//ComboBoxEx32
});
