jls.loader.provide('jls.win32.ComboBoxElement');

jls.loader.require('jls.win32.WindowElement');
jls.loader.require('jls.win32.ComboBox');

jls.win32.ComboBoxElement = jls.lang.Class.create(jls.win32.WindowElement,
{
    initialize : function($super, parameters, parent) {
        this._text = '';
    	// TODO Fix this
    	this._comboHeight = 100;
        $super(parameters, parent);
    	//jls.logger.warn('jls.win32.ComboBoxElement id: ' + this._windowId + ', handle: ' + this._window.handle());
    },
    onCreate : function() {
        this._window = new jls.win32.ComboBox(this.getText(), this.getWindowStyle(),
                this.getX(), this.getY(), this.getW(), this._comboHeight,
                this.getParentWindow(true), this.getWindowId(true), this.getWindowExStyle());
    },
    onWindowMessage: function($super, message, wParam, lParam) {
    	//jls.logger.warn('onWindowMessage(' + jls.win32.Window.getMessageName(message) + ', ' + wParam + ', ' + lParam + ')');
        switch(message) {
        case jls.win32.Window.WM_CTLNOTIFY:
        	//jls.logger.warn('onCtlNotify(' + jls.win32.Window.getMessageName(lParam, jls.win32.ComboBox, 'CBN_') + ')');
        	if (wParam != this._windowId) {
        		break;
        	}
            switch(lParam) {
            case jls.win32.ComboBox.CBN_SELENDOK : // jls.win32.ComboBox.CBN_SELCHANGE:
                var event = new jls.gui.Event('change', this);
                this.dispatch(event);
            	break;
            }
        	
        	break;
        }
        $super(message, wParam, lParam);
    },
    getWindowStyle : function($super) {
        return $super() | jls.win32.ComboBox.CBS_DROPDOWN | jls.win32.ComboBox.CBS_HASSTRINGS;
    },
    getComboHeight : function() {
        return this._comboHeight;
    },
    setComboHeight : function(comboHeight) {
        this._comboHeight = comboHeight;
    },
    getText : function() {
        if (this._window != null) {
            return this._window.getCurrentSelectionText();
        }
        return this._text;
    },
    setText : function(value) {
        if (this._window != null) {
        	// TODO
            this._window.setText(value);
        }
        this._text = value;
        return this;
    },
    addChild : function(child) {
        if (this._window != null) {
            this._window.addString(child.toString());
            //this._children.push(child);
        }
        return this;
    }
});

