jls.loader.provide('jls.win32.CommonDialog');

jls.loader.require('jls.win32.Window');

jls.win32.CommonDialog = jls.lang.Class.create({});

Object.extend(jls.win32.CommonDialog,
{
	getFileName : function(save, window, flags) {
		var nw = null;
		if (window && (window instanceof jls.win32.Window)) {
			nw = window._no;
		}
		if (typeof flags == 'undefined') {
			flags = jls.win32.CommonDialog.OFN_LONGNAMES | jls.win32.CommonDialog.OFN_NOCHANGEDIR;
		}
        return _native.win32.getFileName(save || false, nw, flags);
    },
	getOpenFileName : function(window, flags) {
        return jls.win32.CommonDialog.getFileName(false, window, flags);
    },
	getSaveFileName : function(window, flags) {
        return jls.win32.CommonDialog.getFileName(true, window, flags);
    },
    OFN_ALLOWMULTISELECT:   0x00000200,
    OFN_CREATEPROMPT:       0x00002000,
    OFN_EXPLORER:           0x00080000,
    OFN_EXTENSIONDIFFERENT: 0x00000400,
    OFN_FILEMUSTEXIST:      0x00001000,
    OFN_FORCESHOWHIDDEN:    0x10000000,
    OFN_HIDEREADONLY:       0x00000004,
    OFN_LONGNAMES:          0x00200000,
    OFN_NOCHANGEDIR:        0x00000008,
    OFN_NODEREFERENCELINKS: 0x00100000,
    OFN_NOLONGNAMES:        0x00040000,
    OFN_NOREADONLYRETURN:   0x00008000,
    OFN_OVERWRITEPROMPT:    0x00000002,
    OFN_PATHMUSTEXIST:      0x00000800,
    OFN_READONLY:           0x00000001
    
});
