jls.loader.provide('jls.win32.DeviceContext');

jls.loader.requireLibrary('jls_win32');

jls.loader.require('jls.win32.Window');
jls.loader.require('jls.win32.Font');
jls.loader.require('jls.win32.Pen');
jls.loader.require('jls.win32.Brush');

jls.win32.DeviceContext = jls.lang.Class.create(
{
    initialize : function(window) {
        if (! (window instanceof jls.win32.Window)) {
            throw new jls.lang.Exception('Invalid window argument type (' + (typeof window) + ')');
        }
        this._no = new _native.win32.DeviceContext(window._no);
    },
    drawText : function(text, left, top, right, bottom, count, flags) {
        this._no.drawText(text, left, top, right, bottom, count || -1, flags || jls.win32.DeviceContext.DT_LEFT);
        return this;
    },
    /*setDIBits : function(buffer, width, height, left, top, topDown) {
        this._no.setDIBits(buffer._barray, width, height, left, top, topDown);
        return this;
    },*/
    setDIBits : function(img, left, top) {
        this._no.setDIBits(img.getBuffer().byteArray(), img.getWidth(), img.getHeight(),
        		left, top, img.getOrientation() == jls.util.Image.BOTTOM_LEFT);
        return this;
    },
    /*stretchDIBits : function(buffer, width, height, destWidth, destHeight, topDown) {
        this._no.stretchDIBits(buffer._barray, width, height, destWidth, destHeight, topDown);
        return this;
    },*/
    stretchDIBits : function(img, width, height) {
        this._no.stretchDIBits(img.getBuffer().byteArray(), img.getWidth(), img.getHeight(),
        		width, height, img.getOrientation() == jls.util.Image.BOTTOM_LEFT);
        return this;
    },
    selectObject : function(obj) {
        if (! ((obj instanceof jls.win32.Font) || (obj instanceof jls.win32.Brush) || (obj instanceof jls.win32.Pen))) {
            throw new jls.lang.Exception('Invalid Object argument type (' + (typeof obj) + ')');
        }
        this._no.selectObject(obj._no);
        return this;
    },
    setBkMode : function(transparent) {
        this._no.setBkMode(transparent);
        return this;
    },
    setTextColor : function(r, g, b) {
        this._no.setTextColor(r, g, b);
        return this;
    },
    setBkColor : function(r, g, b) {
        this._no.setBkColor(r, g, b);
        return this;
    },
    rectangle : function(left, top, right, bottom, width, height) {
        this._no.rectangle(left, top, right, bottom, width, height);
        return this;
    },
    ellipse : function(left, top, right, bottom, width, height) {
        this._no.ellipse(left, top, right, bottom, width, height);
        return this;
    },
    fillRect : function(left, top, right, bottom, brush) {
        this._no.fillRect(left, top, right, bottom, brush._no);
        return this;
    },
    release : function() {
        this._no.release();
        this._no = null;
        return this;
    }
});

/*Object.extend(jls.win32.DeviceContext,
{
    _nop : null,
    nop : function() {
    }
});*/

Object.inheritConstants(jls.win32.DeviceContext, _native.win32.DeviceContext);
