jls.loader.provide('jls.win32.Edit');

jls.loader.require('jls.win32.Window');

jls.win32.Edit = jls.lang.Class.create(jls.win32.Window,
{
    initialize : function($super, name, style, x, y, w, h, parent, id, exStyle, param) {
        $super(jls.win32.Edit.CLASSNAME, name, style, x, y, w, h, parent, id, exStyle, param);
    },
    setSelection : function(start, end) {
    	if (typeof start == 'undefined') {
    		start = -1;
    	}
    	if (typeof end == 'undefined') {
    		start = -1;
    	}
        this.sendMessage(jls.win32.Edit.EM_SETSEL, start, end);
    },
    appendText : function(text) {
        this.setSelection(-1, -1);
        this.replaceSelection(text);
    },
    replaceLastLine : function(text) {
        var lineCount = this.sendMessage(jls.win32.Edit.EM_GETLINECOUNT);
        var lineIndex = this.sendMessage(jls.win32.Edit.EM_LINEINDEX, lineCount - 1);
        var textLength = this.getTextLength();
        //jls.logger.warn('replaceLastLine() lineCount: ' + lineCount + ', lineIndex: ' + lineIndex + ', textLength: ' + textLength);
        this.setSelection(lineIndex, -1);
        this.replaceSelection(text);
    },
    replaceSelection : function(text) {
        this.sendMessage(jls.win32.Edit.EM_REPLACESEL, 0, text, true);
    }
});

Object.extend(jls.win32.Edit,
{
    ES_AUTOHSCROLL           : 0x00000080,
    ES_AUTOVSCROLL           : 0x00000040,
    ES_CENTER                : 0x00000001,
    ES_LEFT                  : 0x00000000,
    ES_LOWERCASE             : 0x00000010,
    ES_MULTILINE             : 0x00000004,
    ES_NOHIDESEL             : 0x00000100,
    ES_NUMBER                : 0x00002000,
    ES_OEMCONVERT            : 0x00000400,
    ES_PASSWORD              : 0x00000020,
    ES_READONLY              : 0x00000800,
    ES_RIGHT                 : 0x00000002,
    ES_UPPERCASE             : 0x00000008,
    ES_WANTRETURN            : 0x00001000,
    
    EM_CANUNDO               : 0x000000c6,
    EM_CHARFROMPOS           : 0x000000d7,
    EM_EMPTYUNDOBUFFER       : 0x000000cd,
    EM_FMTLINES              : 0x000000c8,
    EM_GETFIRSTVISIBLELINE   : 0x000000ce,
    EM_GETHANDLE             : 0x000000bd,
    EM_GETLIMITTEXT          : 0x000000d5,
    EM_GETLINE               : 0x000000c4,
    EM_GETLINECOUNT          : 0x000000ba,
    EM_GETMARGINS            : 0x000000d4,
    EM_GETMODIFY             : 0x000000b8,
    EM_GETPASSWORDCHAR       : 0x000000d2,
    EM_GETRECT               : 0x000000b2,
    EM_GETSEL                : 0x000000b0,
    EM_GETTHUMB              : 0x000000be,
    EM_GETWORDBREAKPROC      : 0x000000d1,
    EM_LIMITTEXT             : 0x000000c5,
    EM_LINEFROMCHAR          : 0x000000c9,
    EM_LINEINDEX             : 0x000000bb,
    EM_LINELENGTH            : 0x000000c1,
    EM_LINESCROLL            : 0x000000b6,
    EM_POSFROMCHAR           : 0x000000d6,
    EM_REPLACESEL            : 0x000000c2,
    EM_SCROLL                : 0x000000b5,
    EM_SCROLLCARET           : 0x000000b7,
    EM_SETHANDLE             : 0x000000bc,
    EM_SETLIMITTEXT          : 0x000000c5,
    EM_SETMARGINS            : 0x000000d3,
    EM_SETMODIFY             : 0x000000b9,
    EM_SETPASSWORDCHAR       : 0x000000cc,
    EM_SETREADONLY           : 0x000000cf,
    EM_SETRECT               : 0x000000b3,
    EM_SETRECTNP             : 0x000000b4,
    EM_SETSEL                : 0x000000b1,
    EM_SETTABSTOPS           : 0x000000cb,
    EM_SETWORDBREAKPROC      : 0x000000d0,
    EM_UNDO                  : 0x000000c7,
    
    EN_CHANGE                : 0x00000300,
    EN_ERRSPACE              : 0x00000500,
    EN_HSCROLL               : 0x00000601,
    EN_KILLFOCUS             : 0x00000200,
    EN_MAXTEXT               : 0x00000501,
    EN_SETFOCUS              : 0x00000100,
    EN_UPDATE                : 0x00000400,
    EN_VSCROLL               : 0x00000602,

    CLASSNAME: 'Edit'
});
